/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Function;

public class Triple<A, B, C> {
    private final A first;
    private final B second;
    private final C third;

    public Triple(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <A, B, C> Triple<A, B, C> of(A first, B second, C third) {
        return new Triple<A, B, C>(first, second, third);
    }

    public final A getFirst() {
        return this.first;
    }

    public final B getSecond() {
        return this.second;
    }

    public final C getThird() {
        return this.third;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ", " + this.third + ")";
    }

    private static boolean equals(Object x, Object y) {
        return x == null && y == null || x != null && x.equals(y);
    }

    public boolean equals(Object other) {
        return other instanceof Triple && Triple.equals(this.first, ((Triple)other).first) && Triple.equals(this.second, ((Triple)other).second) && Triple.equals(this.third, ((Triple)other).third);
    }

    public int hashCode() {
        if (this.first == null && this.second == null) {
            return this.third == null ? 0 : this.third.hashCode() + 1;
        }
        if (this.first == null && this.third == null) {
            return this.second.hashCode() + 2;
        }
        if (this.first == null) {
            return this.second.hashCode() * 7 + this.third.hashCode();
        }
        if (this.second == null && this.third == null) {
            return this.first.hashCode() + 3;
        }
        if (this.second == null) {
            return this.first.hashCode() * 11 + this.third.hashCode();
        }
        if (this.third == null) {
            return this.first.hashCode() * 13 + this.second.hashCode();
        }
        return this.first.hashCode() * 17 + this.second.hashCode() * 5 + this.third.hashCode();
    }

    public static <T> Function<Triple<? extends T, ?, ?>, T> getProjectionToFirst() {
        return Holder.getInstance().PROJECTION_TO_FIRST;
    }

    public static <T> Function<Triple<?, ? extends T, ?>, T> getProjectionToSecond() {
        return Holder.getInstance().PROJECTION_TO_SECOND;
    }

    public static <T> Function<Triple<?, ?, ? extends T>, T> getProjectionToThird() {
        return Holder.getInstance().PROJECTION_TO_THIRD;
    }

    private static final class Holder<T, T2> {
        private static final Holder<?, ?> INSTANCE = new Holder();
        private final Function<Triple<? extends T, ?, ?>, T> PROJECTION_TO_FIRST = new Function<Triple<? extends T, ?, ?>, T>(){

            public T apply(Triple<? extends T, ?, ?> pArg0) {
                return pArg0.getFirst();
            }
        };
        private final Function<Triple<?, ? extends T, ?>, T> PROJECTION_TO_SECOND = new Function<Triple<?, ? extends T, ?>, T>(){

            public T apply(Triple<?, ? extends T, ?> pArg0) {
                return pArg0.getSecond();
            }
        };
        private final Function<Triple<?, ?, ? extends T>, T> PROJECTION_TO_THIRD = new Function<Triple<?, ?, ? extends T>, T>(){

            public T apply(Triple<?, ?, ? extends T> pArg0) {
                return pArg0.getThird();
            }
        };

        private Holder() {
        }

        public static <T, T2> Holder<T, T2> getInstance() {
            return INSTANCE;
        }
    }
}

