/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectArrays;
import com.google.common.io.Closeables;
import com.google.common.primitives.Primitives;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.OptionCollector;
import org.sosy_lab.common.configuration.OptionDetailAnnotation;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.configuration.converters.BaseTypeConverter;
import org.sosy_lab.common.configuration.converters.ClassTypeConverter;
import org.sosy_lab.common.configuration.converters.IntegerTypeConverter;
import org.sosy_lab.common.configuration.converters.TimeSpanTypeConverter;
import org.sosy_lab.common.configuration.converters.TypeConverter;

@Options
public class Configuration {
    @Option(name="log.usedOptions.export", description="all used options are printed")
    private boolean exportUsedOptions = false;
    private static final Splitter ARRAY_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final Map<Class<? extends Iterable<?>>, Class<? extends Iterable<?>>> COLLECTIONS;
    private static final Map<Class<?>, TypeConverter> DEFAULT_CONVERTERS;
    private final ImmutableMap<String, String> properties;
    private final String prefix;
    private final ImmutableMap<Class<?>, TypeConverter> converters;
    private final Set<String> unusedProperties;
    private final Set<String> deprecatedProperties;

    public static Builder builder() {
        return new Builder();
    }

    public static Configuration defaultConfiguration() {
        return new Configuration((ImmutableMap<String, String>)ImmutableMap.of(), "", ImmutableMap.copyOf(DEFAULT_CONVERTERS), new HashSet<String>(0), new HashSet<String>(0));
    }

    public static Configuration copyWithNewPrefix(Configuration oldConfig, String newPrefix) {
        Configuration newConfig = new Configuration(oldConfig.properties, newPrefix, oldConfig.converters, oldConfig.unusedProperties, oldConfig.deprecatedProperties);
        newConfig.exportUsedOptions = oldConfig.exportUsedOptions;
        return newConfig;
    }

    private static <T extends Iterable<?>> void putSafely(ImmutableMap.Builder<Class<? extends Iterable<?>>, Class<? extends Iterable<?>>> builder, Class<T> iface, Class<? extends T> impl) {
        assert (!impl.isInterface());
        builder.put(iface, impl);
    }

    public static Map<Class<?>, TypeConverter> getDefaultConverters() {
        return DEFAULT_CONVERTERS;
    }

    private static Map<Class<?>, TypeConverter> createConverterMap() {
        return MapConstraints.constrainedMap(new HashMap(), (MapConstraint)new MapConstraint<Class<?>, TypeConverter>(){

            public void checkKeyValue(Class<?> cls, TypeConverter pValue) {
                Preconditions.checkNotNull(cls);
                Preconditions.checkNotNull((Object)pValue);
                if (cls.isAnnotation() && !cls.isAnnotationPresent(OptionDetailAnnotation.class)) {
                    throw new IllegalArgumentException("Can register type converters only for annotations which are option detail annotations");
                }
            }

            public String toString() {
                return "valid type converter registration";
            }
        });
    }

    private Configuration(ImmutableMap<String, String> pProperties, String pPrefix, ImmutableMap<Class<?>, TypeConverter> pConverters, Set<String> pUnusedProperties, Set<String> pDeprecatedProperties) {
        this.properties = pProperties;
        this.prefix = pPrefix.isEmpty() ? "" : pPrefix + ".";
        this.converters = pConverters;
        this.unusedProperties = pUnusedProperties;
        this.deprecatedProperties = pDeprecatedProperties;
    }

    public String getProperty(String key) {
        String result = (String)this.properties.get((Object)(this.prefix + key));
        this.unusedProperties.remove(this.prefix + key);
        if (result == null && !this.prefix.isEmpty()) {
            result = (String)this.properties.get((Object)key);
            this.unusedProperties.remove(key);
        }
        return result;
    }

    @Deprecated
    public String getProperty(String key, String defaultValue) {
        String result = this.getProperty(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public String[] getPropertiesArray(String key) {
        String s = this.getProperty(key);
        return s != null ? (String[])Iterables.toArray((Iterable)ARRAY_SPLITTER.split((CharSequence)s), String.class) : new String[]{};
    }

    public Set<String> getUnusedProperties() {
        return Collections.unmodifiableSet(this.unusedProperties);
    }

    public Set<String> getDeprecatedProperties() {
        return Collections.unmodifiableSet(this.deprecatedProperties);
    }

    public void inject(Object obj) throws InvalidConfigurationException {
        this.inject(obj, obj.getClass());
    }

    public void recursiveInject(Object obj) throws InvalidConfigurationException {
        Class<?> cls = obj.getClass();
        Preconditions.checkNotNull((Object)cls.getAnnotation(Options.class), (Object)("Class " + cls.getName() + " must have @Options annotation."));
        do {
            if (!cls.isAnnotationPresent(Options.class)) continue;
            this.inject(obj, cls);
        } while ((cls = cls.getSuperclass()) != null);
    }

    public void inject(Object obj, Class<?> cls) throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)obj);
        Preconditions.checkNotNull(cls);
        Preconditions.checkArgument((boolean)cls.isAssignableFrom(obj.getClass()));
        Options options = cls.getAnnotation(Options.class);
        Preconditions.checkNotNull((Object)options, (Object)("Class " + cls.getName() + " must have @Options annotation.  If you used inject(Object), try" + " inject(Object, Class) instead."));
        AccessibleObject[] fields = cls.getDeclaredFields();
        Field.setAccessible(fields, true);
        AccessibleObject[] methods = cls.getDeclaredMethods();
        Method.setAccessible(methods, true);
        try {
            for (AccessibleObject field : fields) {
                if (!field.isAnnotationPresent(Option.class)) continue;
                this.setOptionValueForField(obj, (Field)field, options);
            }
            for (AccessibleObject method : methods) {
                if (!method.isAnnotationPresent(Option.class)) continue;
                this.setOptionValueForMethod(obj, (Method)method, options);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <T> void setOptionValueForField(Object obj, Field field, Options options) throws InvalidConfigurationException, IllegalAccessException {
        block8: {
            Object defaultValue;
            block7: {
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new UnsupportedOperationException("@Option is not allowed on static members");
                }
                if (Modifier.isFinal(field.getModifiers())) {
                    throw new UnsupportedOperationException("@Option is not allowed on final fields because Java doesn't guarantee visibility of new value");
                }
                defaultValue = null;
                try {
                    defaultValue = field.get(obj);
                }
                catch (IllegalArgumentException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)"Type checks above were not successful apparently.");
                }
            }
            Object typedDefaultValue = defaultValue;
            Class<?> type = field.getType();
            Type genericType = field.getGenericType();
            Option option = field.getAnnotation(Option.class);
            String name = this.getOptionName(options, field, option);
            Object value = this.getValue(name, typedDefaultValue, type, genericType, option, field);
            if (value == defaultValue) {
                return;
            }
            try {
                field.set(obj, value);
            }
            catch (IllegalArgumentException e) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)"Type checks above were not successful apparently.");
            }
        }
    }

    private void setOptionValueForMethod(Object obj, Method method, Options options) throws InvalidConfigurationException, IllegalAccessException {
        if (Modifier.isStatic(method.getModifiers())) {
            throw new UnsupportedOperationException("@Option is not allowed on static members");
        }
        String exception = Classes.verifyDeclaredExceptions(method, InvalidConfigurationException.class);
        if (exception != null) {
            throw new UnsupportedOperationException("Method with @Option may not throw " + exception);
        }
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length != 1) {
            throw new UnsupportedOperationException("Method with @Option must have exactly one parameter!");
        }
        Class<?> type = parameters[0];
        Type genericType = method.getGenericParameterTypes()[0];
        Option option = method.getAnnotation(Option.class);
        String name = this.getOptionName(options, method, option);
        Object value = this.getValue(name, null, type, genericType, option, method);
        try {
            method.invoke(obj, value);
        }
        catch (IllegalArgumentException e) {
            assert (false) : "Type checks above were not successful apparently.";
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalArgumentException) {
                throw new InvalidConfigurationException("Invalid value in configuration file: \"" + name + " = " + value + '\"' + (t.getMessage() != null ? " (" + t.getMessage() + ")" : ""), t);
            }
            Throwables.propagateIfPossible((Throwable)t, InvalidConfigurationException.class);
            throw new Classes.UnexpectedCheckedException("configuration injection in method " + method, t);
        }
    }

    private String getOptionName(Options options, Member member, Option option) {
        String name;
        String prefix = options.prefix();
        if (!prefix.isEmpty()) {
            prefix = prefix + ".";
        }
        if ((name = option.name()).isEmpty()) {
            name = member.getName();
        }
        return prefix + name;
    }

    private <T> Object getValue(String optionName, T defaultValue, Class<T> type, Type genericType, Option option, AnnotatedElement member) throws UnsupportedOperationException, InvalidConfigurationException {
        Object value;
        String valueStr = this.getValueString(optionName, option, type.isEnum());
        Annotation secondaryOption = this.getSecondaryAnnotation(member);
        if (valueStr != null) {
            value = this.convertValue(optionName, valueStr, type, genericType, secondaryOption);
            if (member.isAnnotationPresent(Deprecated.class)) {
                this.deprecatedProperties.add(optionName);
            }
        } else {
            if (option.required()) {
                throw new InvalidConfigurationException("Required configuration option " + optionName + " is missing.");
            }
            value = this.convertDefaultValue(optionName, defaultValue, type, genericType, secondaryOption);
        }
        if (this.exportUsedOptions) {
            this.printOptionInfos(type, option, optionName, valueStr, defaultValue);
        }
        return value;
    }

    private String getValueString(String name, Option option, boolean alwaysUppercase) throws InvalidConfigurationException {
        String[] allowedValues;
        String valueStr = Configuration.trimToNull(this.getProperty(name));
        if (valueStr == null) {
            return null;
        }
        if (alwaysUppercase || option.toUppercase()) {
            valueStr = valueStr.toUpperCase();
        }
        if ((allowedValues = option.values()).length > 0 && !Arrays.asList(allowedValues).contains(valueStr)) {
            throw new InvalidConfigurationException("Invalid value in configuration file: \"" + name + " = " + valueStr + '\"' + " (not listed as allowed value)");
        }
        String regexp = option.regexp();
        if (!regexp.isEmpty() && !valueStr.matches(regexp)) {
            throw new InvalidConfigurationException("Invalid value in configuration file: \"" + name + " = " + valueStr + '\"' + " (does not match RegExp \"" + regexp + "\")");
        }
        return valueStr;
    }

    private Annotation getSecondaryAnnotation(AnnotatedElement element) {
        Annotation result = null;
        for (Annotation a : element.getDeclaredAnnotations()) {
            if (!a.annotationType().isAnnotationPresent(OptionDetailAnnotation.class)) continue;
            if (result != null) {
                throw new UnsupportedOperationException("Both " + result + " and " + a + " are present at " + element.toString());
            }
            result = a;
        }
        return result;
    }

    private void checkApplicability(Annotation annotation, Class<?> optionType) throws UnsupportedOperationException {
        if (annotation == null) {
            return;
        }
        Class<?>[] applicableTypes = annotation.annotationType().getAnnotation(OptionDetailAnnotation.class).applicableTo();
        boolean applicable = false;
        for (Class<?> candidate : applicableTypes) {
            if (!candidate.isAssignableFrom(optionType)) continue;
            return;
        }
        if (!applicable) {
            throw new UnsupportedOperationException("Annotation " + annotation + " is not applicable for options of type " + optionType.getCanonicalName());
        }
    }

    private void printOptionInfos(Class<?> type, Option option, String name, String valueStr, Object defaultValue) {
        StringBuilder optionInfo = new StringBuilder(OptionCollector.formatText(option.description()));
        optionInfo.append(name + "\n");
        if (type.isArray()) {
            optionInfo.append("    default value:  " + Arrays.deepToString((Object[])defaultValue) + "\n");
        } else if (type.equals(String.class)) {
            optionInfo.append("    default value:  '" + defaultValue + "'\n");
        } else {
            optionInfo.append("    default value:  " + defaultValue + "\n");
        }
        if (valueStr != null) {
            optionInfo.append("--> used value:     " + valueStr + "\n");
        }
        System.out.println(optionInfo.toString());
    }

    private <T> Object convertValue(String optionName, String valueStr, Class<?> pType, Type genericType, Annotation secondaryOption) throws UnsupportedOperationException, InvalidConfigurationException {
        Class<?> componentType;
        Class<? extends Iterable<?>> collectionClass = COLLECTIONS.get(pType);
        if (collectionClass == null && !pType.isArray()) {
            Class type = Primitives.wrap(pType);
            this.checkApplicability(secondaryOption, type);
            return this.convertSingleValue(optionName, valueStr, type, genericType, secondaryOption);
        }
        ParameterizedType componentGenericType = null;
        if (pType.isArray()) {
            componentType = pType.getComponentType();
        } else {
            Pair<Class<?>, ParameterizedType> p = Classes.getComponentType(genericType);
            componentType = p.getFirst();
            componentGenericType = p.getSecond();
        }
        componentType = Primitives.wrap(componentType);
        this.checkApplicability(secondaryOption, componentType);
        List<?> values = this.convertMultipleValues(optionName, valueStr, componentType, componentGenericType, secondaryOption);
        if (pType.isArray()) {
            Class<?> arrayComponentType = componentType;
            Object[] result = ObjectArrays.newArray(arrayComponentType, (int)values.size());
            return values.toArray(result);
        }
        return BaseTypeConverter.invokeStaticMethod(collectionClass, "copyOf", Iterable.class, values, optionName);
    }

    private Object convertSingleValue(String optionName, String valueStr, Class<?> type, Type genericType, Annotation secondaryOption) throws InvalidConfigurationException {
        TypeConverter converter = this.getConverter(type, secondaryOption);
        return converter.convert(optionName, valueStr, type, genericType, secondaryOption);
    }

    private List<?> convertMultipleValues(String optionName, String valueStr, Class<?> type, Type genericType, Annotation secondaryOption) throws InvalidConfigurationException {
        Iterable values = ARRAY_SPLITTER.split((CharSequence)valueStr);
        ArrayList<Object> result = new ArrayList<Object>();
        for (String item : values) {
            result.add(this.convertSingleValue(optionName, item, type, genericType, secondaryOption));
        }
        return result;
    }

    private <T> Object convertDefaultValue(String optionName, T defaultValue, Class<T> type, Type genericType, Annotation secondaryOption) throws InvalidConfigurationException {
        Class<Object> innerType = type.isArray() ? type.getComponentType() : (COLLECTIONS.containsKey(type) ? Classes.getComponentType(genericType).getFirst() : type);
        innerType = Primitives.wrap(innerType);
        this.checkApplicability(secondaryOption, innerType);
        if (type == innerType) {
            TypeConverter converter = this.getConverter(type, secondaryOption);
            return converter.convertDefaultValue(optionName, defaultValue, type, genericType, secondaryOption);
        }
        return defaultValue;
    }

    private TypeConverter getConverter(Class<?> type, Annotation secondaryOption) {
        TypeConverter converter = null;
        if (secondaryOption != null) {
            converter = (TypeConverter)this.converters.get(secondaryOption.annotationType());
        }
        if (converter == null) {
            converter = (TypeConverter)this.converters.get(type);
        }
        if (converter == null) {
            converter = BaseTypeConverter.INSTANCE;
        }
        return converter;
    }

    private static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        return Strings.emptyToNull((String)s.trim());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Configuration.putSafely(builder, Iterable.class, ImmutableList.class);
        Configuration.putSafely(builder, Collection.class, ImmutableList.class);
        Configuration.putSafely(builder, List.class, ImmutableList.class);
        Configuration.putSafely(builder, Set.class, ImmutableSet.class);
        Configuration.putSafely(builder, SortedSet.class, ImmutableSortedSet.class);
        Configuration.putSafely(builder, Multiset.class, ImmutableMultiset.class);
        Configuration.putSafely(builder, ImmutableCollection.class, ImmutableList.class);
        Configuration.putSafely(builder, ImmutableList.class, ImmutableList.class);
        Configuration.putSafely(builder, ImmutableSet.class, ImmutableSet.class);
        Configuration.putSafely(builder, ImmutableSortedSet.class, ImmutableSortedSet.class);
        Configuration.putSafely(builder, ImmutableMultiset.class, ImmutableMultiset.class);
        COLLECTIONS = builder.build();
        DEFAULT_CONVERTERS = Collections.synchronizedMap(Configuration.createConverterMap());
        DEFAULT_CONVERTERS.put(Class.class, new ClassTypeConverter());
        DEFAULT_CONVERTERS.put(IntegerOption.class, new IntegerTypeConverter());
        DEFAULT_CONVERTERS.put(TimeSpanOption.class, new TimeSpanTypeConverter());
    }

    public static class Builder {
        private Map<String, String> properties = null;
        private Configuration oldConfig = null;
        private String prefix = null;
        private Map<Class<?>, TypeConverter> converters = null;

        private Builder() {
        }

        private void setupProperties() {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            if (this.oldConfig != null) {
                this.properties.putAll((Map<String, String>)this.oldConfig.properties);
            }
        }

        public Builder setOption(String name, String value) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)value);
            this.setupProperties();
            this.properties.put(name, value);
            return this;
        }

        public Builder clearOption(String name) {
            Preconditions.checkNotNull((Object)name);
            this.setupProperties();
            this.properties.remove(name);
            return this;
        }

        public Builder setOptions(Map<String, String> options) {
            Preconditions.checkNotNull(options);
            this.setupProperties();
            this.properties.putAll(options);
            return this;
        }

        public Builder setPrefix(String prefix) {
            Preconditions.checkNotNull((Object)prefix);
            this.prefix = prefix;
            return this;
        }

        public Builder copyFrom(Configuration oldConfig) {
            Preconditions.checkNotNull((Object)oldConfig);
            Preconditions.checkState((this.properties == null ? 1 : 0) != 0);
            Preconditions.checkState((this.oldConfig == null ? 1 : 0) != 0);
            Preconditions.checkState((this.converters == null ? 1 : 0) != 0);
            this.oldConfig = oldConfig;
            return this;
        }

        public Builder loadFromStream(InputStream stream) throws IOException {
            Preconditions.checkNotNull((Object)stream);
            this.setupProperties();
            Properties p = new Properties();
            p.load(stream);
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                this.properties.put((String)e.getKey(), (String)e.getValue());
            }
            return this;
        }

        public Builder loadFromFile(String filename) throws IOException {
            return this.loadFromFile(new File(filename));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder loadFromFile(File file) throws IOException {
            Preconditions.checkNotNull((Object)file);
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                this.loadFromStream(stream);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stream);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)stream);
            return this;
        }

        public Builder addConverter(Class<?> cls, TypeConverter converter) {
            Preconditions.checkNotNull(cls);
            Preconditions.checkNotNull((Object)converter);
            if (this.converters == null) {
                this.converters = Configuration.createConverterMap();
                if (this.oldConfig != null) {
                    this.converters.putAll((Map<Class<?>, TypeConverter>)this.oldConfig.converters);
                } else {
                    this.converters.putAll(DEFAULT_CONVERTERS);
                }
            }
            this.converters.put(cls, converter);
            return this;
        }

        public Configuration build() throws InvalidConfigurationException {
            HashSet newDeprecatedProperties;
            HashSet newUnusedProperties;
            ImmutableMap newProperties = this.properties == null ? (this.oldConfig != null ? this.oldConfig.properties : ImmutableMap.of()) : ImmutableMap.copyOf(this.properties);
            String newPrefix = this.prefix == null ? (this.oldConfig != null ? this.oldConfig.prefix : "") : this.prefix;
            ImmutableMap newConverters = this.converters == null ? (this.oldConfig != null ? this.oldConfig.converters : ImmutableMap.copyOf((Map)DEFAULT_CONVERTERS)) : ImmutableMap.copyOf(this.converters);
            if (this.oldConfig != null) {
                newUnusedProperties = this.oldConfig.unusedProperties;
                newDeprecatedProperties = this.oldConfig.deprecatedProperties;
            } else {
                newUnusedProperties = new HashSet(newProperties.keySet());
                newDeprecatedProperties = new HashSet(0);
            }
            Configuration newConfig = new Configuration(newProperties, newPrefix, newConverters, newUnusedProperties, newDeprecatedProperties);
            newConfig.inject(newConfig);
            this.properties = null;
            this.prefix = null;
            this.oldConfig = null;
            return newConfig;
        }
    }
}

