/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;

public class OptionCollector {
    private static final int CHARS_PER_LINE = 75;
    private static final HashSet<String> errorMessages = new LinkedHashSet<String>();
    private static String sourcePath = "";

    public static void main(String[] args) {
        boolean verbose = false;
        for (String arg : args) {
            if (!"-v".equals(arg) && !"-verbose".equals(arg)) continue;
            verbose = true;
        }
        System.out.println(OptionCollector.getCollectedOptions(verbose));
    }

    public static String getCollectedOptions(boolean verbose) {
        sourcePath = OptionCollector.getSourcePath();
        TreeMap<String, Pair<String, String>> map = new TreeMap<String, Pair<String, String>>();
        PrintStream originalStdOut = System.out;
        System.setOut(System.err);
        boolean appendCommonOptions = true;
        for (Class<?> c : OptionCollector.getClasses()) {
            OptionCollector.collectOptions(c, map, verbose);
            if (!c.getPackage().getName().startsWith("org.sosy_lab.common")) continue;
            appendCommonOptions = false;
        }
        System.setOut(originalStdOut);
        for (String error : errorMessages) {
            System.err.println(error);
        }
        StringBuilder content = new StringBuilder();
        if (appendCommonOptions) {
            try {
                content.append(Resources.toString((URL)Resources.getResource((String)"org/sosy_lab/common/ConfigurationOptions.txt"), (Charset)Charsets.UTF_8));
            }
            catch (Exception e) {
                System.err.println("Could not find options of org.sosy-lab.common classes: " + e.getMessage());
            }
        }
        String description = "";
        for (Pair descriptionAndInfo : map.values()) {
            if (((String)descriptionAndInfo.getFirst()).isEmpty() || !description.equals(descriptionAndInfo.getFirst())) {
                content.append("\n");
                content.append((String)descriptionAndInfo.getFirst());
                description = (String)descriptionAndInfo.getFirst();
            }
            content.append((String)descriptionAndInfo.getSecond());
        }
        return content.toString();
    }

    private static String getSourcePath() {
        Enumeration<URL> resources = OptionCollector.getClassLoaderResources();
        while (resources.hasMoreElements()) {
            File file = new File(resources.nextElement().getFile());
            String testPath = file.toString().substring(0, file.toString().length() - 3);
            if (!new File(testPath + "src/org/sosy_lab").isDirectory()) continue;
            return testPath + "src/";
        }
        return "";
    }

    private static Enumeration<URL> getClassLoaderResources() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        Enumeration<URL> resources = null;
        try {
            resources = classLoader.getResources("");
        }
        catch (IOException e) {
            System.err.println("Could not get recources of classloader.");
        }
        return resources;
    }

    private static void collectOptions(Class<?> c, SortedMap<String, Pair<String, String>> map, boolean verbose) {
        for (Field field : c.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Option.class)) continue;
            OptionCollector.getOptionsDescription(c, map);
            String optionName = OptionCollector.getOptionName(c, field);
            String defaultValue = OptionCollector.getDefaultValue(field);
            StringBuilder optionInfo = new StringBuilder();
            optionInfo.append(optionName);
            if (verbose) {
                optionInfo.append("\n  field:    " + field.getName() + "\n");
                optionInfo.append("  class:    " + field.getDeclaringClass().toString().substring(6) + "\n");
                optionInfo.append("  type:     " + field.getType().getSimpleName() + "\n");
                optionInfo.append("  default value: ");
                if (!defaultValue.isEmpty()) {
                    optionInfo.append(defaultValue);
                } else {
                    optionInfo.append("not available");
                }
            } else if (!defaultValue.isEmpty()) {
                optionInfo.append(" = " + defaultValue);
            } else {
                optionInfo.append(" = no default value");
            }
            optionInfo.append("\n");
            optionInfo.append(OptionCollector.getAllowedValues(field, verbose));
            if (map.containsKey(optionName)) {
                String commonOptionInfo;
                Pair oldValues = (Pair)map.get(optionName);
                String description = OptionCollector.getOptionDescription(field);
                if (!description.equals(oldValues.getFirst())) {
                    description = description + (String)oldValues.getFirst();
                }
                if (!(commonOptionInfo = optionInfo.toString()).equals(oldValues.getSecond())) {
                    commonOptionInfo = commonOptionInfo + (String)oldValues.getSecond();
                }
                map.put(optionName, Pair.of(description, commonOptionInfo));
                continue;
            }
            map.put(optionName, Pair.of(OptionCollector.getOptionDescription(field), optionInfo.toString()));
        }
    }

    private static String getOptionDescription(Field field) {
        Option option = field.getAnnotation(Option.class);
        String text = option.description();
        if (field.getAnnotation(Deprecated.class) != null) {
            text = "DEPRECATED: " + text;
        }
        return OptionCollector.formatText(text);
    }

    private static void getOptionsDescription(Class<?> c, SortedMap<String, Pair<String, String>> map) {
        Options classOption;
        if (c.isAnnotationPresent(Options.class) && !(classOption = c.getAnnotation(Options.class)).prefix().isEmpty() && !classOption.description().isEmpty()) {
            map.put(classOption.prefix(), Pair.of(OptionCollector.formatText(classOption.description()), ""));
        }
    }

    public static String formatText(String text) {
        return OptionCollector.formatText(text, "# ", true);
    }

    public static String formatText(String text, String lineStart, boolean useLineStartInFirstLine) {
        if (text.isEmpty()) {
            return text;
        }
        String[] lines = text.split("\n");
        ArrayList<String> splittedLines = new ArrayList<String>();
        for (String line : lines) {
            while (line.length() > 75) {
                String start;
                int spaceIndex = line.lastIndexOf(" ", 75);
                if (spaceIndex == -1) {
                    spaceIndex = line.indexOf(" ");
                }
                if (spaceIndex == -1) {
                    spaceIndex = line.length() - 1;
                }
                if (!(start = line.substring(0, spaceIndex)).isEmpty()) {
                    splittedLines.add(start);
                }
                line = line.substring(spaceIndex + 1);
            }
            splittedLines.add(line);
        }
        if (((String)splittedLines.get(splittedLines.size() - 1)).isEmpty()) {
            splittedLines.remove(splittedLines.size() - 1);
        }
        StringBuilder formattedLines = new StringBuilder();
        if (!useLineStartInFirstLine && splittedLines.size() > 0) {
            formattedLines.append((String)splittedLines.remove(0));
            formattedLines.append('\n');
        }
        for (String line : splittedLines) {
            formattedLines.append(lineStart);
            formattedLines.append(line);
            formattedLines.append('\n');
        }
        return formattedLines.toString();
    }

    private static String getOptionName(Class<?> c, Field field) {
        Option option;
        Options classOption;
        String optionName = "";
        if (c.isAnnotationPresent(Options.class) && !(classOption = c.getAnnotation(Options.class)).prefix().isEmpty()) {
            optionName = optionName + classOption.prefix() + ".";
        }
        optionName = (option = field.getAnnotation(Option.class)).name().isEmpty() ? optionName + field.getName() : optionName + option.name();
        return optionName;
    }

    private static String getDefaultValue(Field field) {
        String content = OptionCollector.getContentOfFile(field);
        String fieldString = Modifier.toString(field.getModifiers());
        String genericType = field.getGenericType().toString();
        if (genericType.matches(".*<.*>")) {
            genericType = genericType.replaceAll("^[^<]*\\.", "");
            genericType = genericType.replaceAll("<[^\\?][^<]*\\.", "<");
            genericType = genericType.replaceAll("<\\?[^<]*\\.", "<\\\\?\\\\s+extends\\\\s+");
            fieldString = fieldString + "\\s+" + genericType;
        } else {
            fieldString = fieldString + "\\s+" + field.getType().getSimpleName();
        }
        fieldString = fieldString + "\\s+" + field.getName();
        String defaultValue = OptionCollector.getDefaultValueFromContent(content, fieldString);
        if (field.getType().isEnum()) {
            if (defaultValue.isEmpty()) {
                String type = field.getType().toString();
                type = type.substring(type.lastIndexOf(".") + 1).replace("$", ".");
                fieldString = Modifier.toString(field.getModifiers()) + "\\s+" + type + "\\s+" + field.getName();
                defaultValue = OptionCollector.getDefaultValueFromContent(content, fieldString);
            }
            if (defaultValue.contains(".")) {
                defaultValue = defaultValue.substring(defaultValue.lastIndexOf(".") + 1);
            }
        }
        if (defaultValue.equals("null")) {
            defaultValue = "";
        }
        return defaultValue;
    }

    private static String getContentOfFile(Field field) {
        String filename = field.getDeclaringClass().toString().substring(6).replace(".", "/");
        if (filename.contains("$")) {
            filename = filename.substring(0, filename.indexOf("$"));
        }
        filename = sourcePath + filename + ".java";
        try {
            return Files.toString((File)new File(filename), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            errorMessages.add("INFO: Could not read sourcefiles for getting the default values.");
            return "";
        }
    }

    private static String getDefaultValueFromContent(String content, String fieldPattern) {
        String defaultValue = "";
        String[] splitted = content.split(fieldPattern);
        if (splitted.length > 1) {
            String rest = splitted[1];
            defaultValue = rest.substring(0, rest.indexOf(";")).trim();
            if (defaultValue.startsWith("=")) {
                defaultValue = defaultValue.substring(1).trim();
                while (defaultValue.contains("/*")) {
                    defaultValue = defaultValue.substring(0, defaultValue.indexOf("/*")) + defaultValue.substring(defaultValue.indexOf("*/") + 2);
                }
                if (defaultValue.contains("//")) {
                    defaultValue = defaultValue.substring(0, defaultValue.indexOf("//"));
                }
                if (defaultValue.startsWith("new File(")) {
                    defaultValue = defaultValue.substring("new File(".length(), defaultValue.length() - 1);
                }
                if (defaultValue.startsWith("ImmutableSet.of(")) {
                    defaultValue = "{" + defaultValue.substring("ImmutableSet.of(".length(), defaultValue.length() - 1) + "}";
                }
            }
        } else {
            String stringSetFieldPattern = fieldPattern.replace("\\s+Set\\s+", "\\s+Set<String>\\s+");
            if (content.contains(stringSetFieldPattern)) {
                return OptionCollector.getDefaultValueFromContent(content, stringSetFieldPattern);
            }
        }
        return defaultValue.trim();
    }

    private static String getAllowedValues(Field field, boolean verbose) {
        String allowedValues = "";
        Class<?> type = field.getType();
        if (type.isEnum()) {
            try {
                Field[] enums = Class.forName(type.toString().substring(6)).getFields();
                Object[] enumTitles = new String[enums.length];
                for (int i = 0; i < enums.length; ++i) {
                    enumTitles[i] = enums[i].getName();
                }
                allowedValues = "  enum:     " + OptionCollector.formatText(Arrays.toString(enumTitles), "             ", false);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        allowedValues = allowedValues + OptionCollector.getOptionValues(field, verbose);
        allowedValues = allowedValues + OptionCollector.getClassOptionValues(field, verbose);
        allowedValues = allowedValues + OptionCollector.getFileOptionValues(field, verbose);
        allowedValues = allowedValues + OptionCollector.getIntegerOptionValues(field, verbose);
        allowedValues = allowedValues + OptionCollector.getTimeSpanOptionValues(field, verbose);
        return allowedValues;
    }

    private static String getOptionValues(Field field, boolean verbose) {
        Option option = field.getAnnotation(Option.class);
        assert (option != null);
        String str = "";
        if (option.values().length != 0) {
            str = str + "  allowed values: " + Arrays.toString(option.values()) + "\n";
        }
        if (verbose && !option.regexp().isEmpty()) {
            str = str + "  regexp:   " + option.regexp() + "\n";
        }
        if (verbose && option.toUppercase()) {
            str = str + "  uppercase: true\n";
        }
        return str;
    }

    private static String getClassOptionValues(Field field, boolean verbose) {
        ClassOption classOption = field.getAnnotation(ClassOption.class);
        String str = "";
        if (classOption != null && verbose && !classOption.packagePrefix().isEmpty()) {
            str = str + "  packagePrefix: " + classOption.packagePrefix() + "\n";
        }
        return str;
    }

    private static String getFileOptionValues(Field field, boolean verbose) {
        FileOption fileOption = field.getAnnotation(FileOption.class);
        String str = "";
        if (fileOption != null && verbose) {
            str = str + "  type of file: " + (Object)((Object)fileOption.value()) + "\n";
        }
        return str;
    }

    private static String getIntegerOptionValues(Field field, boolean verbose) {
        IntegerOption intOption = field.getAnnotation(IntegerOption.class);
        String str = "";
        if (intOption != null && verbose) {
            str = intOption.min() == Long.MIN_VALUE ? str + "  min:      Long.MIN_VALUE\n" : str + "  min:      " + intOption.min() + "\n";
            str = intOption.max() == Long.MAX_VALUE ? str + "  max:      Long.MAX_VALUE\n" : str + "  max:      " + intOption.max() + "\n";
        }
        return str;
    }

    private static String getTimeSpanOptionValues(Field field, boolean verbose) {
        TimeSpanOption timeSpanOption = field.getAnnotation(TimeSpanOption.class);
        String str = "";
        if (timeSpanOption != null && verbose) {
            str = str + "  code unit:     " + (Object)((Object)timeSpanOption.codeUnit()) + "\n";
            str = str + "  default unit:  " + (Object)((Object)timeSpanOption.defaultUserUnit()) + "\n";
            str = timeSpanOption.min() == Long.MIN_VALUE ? str + "  time min:      Long.MIN_VALUE\n" : str + "  time min:      " + timeSpanOption.min() + "\n";
            str = timeSpanOption.max() == Long.MAX_VALUE ? str + "  time max:      Long.MAX_VALUE\n" : str + "  time max:      " + timeSpanOption.max() + "\n";
        }
        return str;
    }

    private static List<Class<?>> getClasses() {
        Enumeration<URL> resources = OptionCollector.getClassLoaderResources();
        ArrayList classes = new ArrayList();
        while (resources.hasMoreElements()) {
            File file = new File(resources.nextElement().getFile());
            OptionCollector.collectClasses(file, "", classes);
        }
        return classes;
    }

    private static void collectClasses(File directory, String packageName, List<Class<?>> classes) {
        if (directory.exists()) {
            Object[] files = directory.listFiles();
            Arrays.sort(files);
            for (Object file : files) {
                String fileName = ((File)file).getName();
                if (((File)file).isDirectory() && !fileName.startsWith(".svn")) {
                    String newPackage = packageName.isEmpty() ? fileName : packageName + "." + fileName;
                    OptionCollector.collectClasses((File)file, newPackage, classes);
                    continue;
                }
                if (!fileName.endsWith(".class")) continue;
                String nameOfClass = packageName + '.' + fileName.substring(0, fileName.length() - 6);
                try {
                    Class<?> foundClass = Class.forName(nameOfClass);
                    if (Modifier.isInterface(foundClass.getModifiers())) continue;
                    classes.add(foundClass);
                }
                catch (ClassNotFoundException e) {
                }
                catch (UnsatisfiedLinkError e) {
                    errorMessages.add("INFO: Could not load '" + fileName + "' for getting Option-annotations: " + e.getMessage());
                }
                catch (NoClassDefFoundError e) {
                    return;
                }
            }
        }
    }
}

