/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration.converters;

import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.converters.TypeConverter;

public enum BaseTypeConverter implements TypeConverter
{
    INSTANCE;


    @Override
    public Object convert(String optionName, String valueStr, Class<?> type, Type pGenericType, Annotation pSecondaryOption) throws InvalidConfigurationException {
        if (Primitives.isWrapperType(type)) {
            return BaseTypeConverter.valueOf(type, optionName, valueStr);
        }
        if (type.isEnum()) {
            try {
                return BaseTypeConverter.convertEnum(type, valueStr);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException("Invalid value " + valueStr + " for option " + optionName);
            }
        }
        if (type.equals(String.class)) {
            return valueStr;
        }
        if (type.equals(Level.class)) {
            try {
                return Level.parse(valueStr);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException("Illegal log level " + valueStr + " in option " + optionName);
            }
        }
        throw new UnsupportedOperationException("Unimplemented type for option: " + type.getSimpleName());
    }

    @Override
    public <T> T convertDefaultValue(String pOptionName, T pValue, Class<T> pType, Type pGenericType, Annotation pSecondaryOption) throws InvalidConfigurationException {
        return pValue;
    }

    private static Object convertEnum(Class<?> cls, String value) {
        return Enum.valueOf(cls, value);
    }

    public static Object valueOf(Class<?> type, String optionName, String value) throws InvalidConfigurationException {
        return BaseTypeConverter.invokeStaticMethod(type, "valueOf", String.class, value, optionName);
    }

    public static <T> Object invokeStaticMethod(Class<?> type, String method, Class<T> paramType, T value, String optionName) throws InvalidConfigurationException {
        try {
            Method m = type.getMethod(method, paramType);
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            return m.invoke(null, value);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("Class " + type.getSimpleName() + " without " + method + "(" + paramType.getSimpleName() + ") method!"));
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)("Class " + type.getSimpleName() + " without accessible " + method + "(" + paramType.getSimpleName() + ") method!"));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Class " + type.getSimpleName() + " without accessible " + method + "(" + paramType.getSimpleName() + ") method!"));
        }
        catch (InvocationTargetException e) {
            throw new InvalidConfigurationException("Could not parse \"" + optionName + " = " + value + "\" (" + e.getTargetException().getMessage() + ")", e);
        }
    }
}

