/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.converters.TypeConverter;

public class ClassTypeConverter
implements TypeConverter {
    @Override
    public Object convert(String optionName, String value, Class<?> type, Type genericType, Annotation secondaryOption) throws InvalidConfigurationException {
        Class<?> cls;
        String packagePrefix = "";
        if (secondaryOption != null) {
            if (!(secondaryOption instanceof ClassOption)) {
                throw new UnsupportedOperationException("Options of type Class may not be annotated with " + secondaryOption);
            }
            packagePrefix = ((ClassOption)secondaryOption).packagePrefix();
        }
        Class<?> targetType = Classes.getComponentType(genericType).getFirst();
        try {
            cls = Classes.forName(value, packagePrefix);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Class " + value + " specified in option " + optionName + " not found");
        }
        if (!targetType.isAssignableFrom(cls)) {
            throw new InvalidConfigurationException("Class " + value + " specified in option " + optionName + " is not an instance of " + targetType.getCanonicalName());
        }
        return cls;
    }

    @Override
    public <T> T convertDefaultValue(String pOptionName, T pValue, Class<T> pType, Type pGenericType, Annotation pSecondaryOption) {
        return pValue;
    }
}

