/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration.converters;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.converters.TypeConverter;

@Options
public class FileTypeConverter
implements TypeConverter {
    @Option(name="output.path", description="directory to put all output files in")
    private String outputDirectory = "output/";
    @Option(name="output.disable", description="disable all default output files\n(any explicitly given file will still be written)")
    private boolean disableOutput = false;
    @Option(description="base directory for all input & output files\n(except for the configuration file itself)")
    private String rootDirectory = ".";

    public FileTypeConverter(Configuration config) throws InvalidConfigurationException {
        config.inject(this, FileTypeConverter.class);
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    private void checkApplicability(Class<?> type, Annotation secondaryOption, String optionName) {
        if (!type.equals(File.class) || !(secondaryOption instanceof FileOption)) {
            throw new UnsupportedOperationException("A FileTypeConverter can handle only options of type File and with a @FileOption annotation, but " + optionName + " does not fit.");
        }
    }

    @Override
    public File convert(String optionName, String pValue, Class<?> pType, Type pGenericType, Annotation secondaryOption) throws InvalidConfigurationException {
        this.checkApplicability(pType, secondaryOption, optionName);
        return this.handleFileOption(optionName, new File(pValue), ((FileOption)secondaryOption).value());
    }

    @Override
    public <T> T convertDefaultValue(String optionName, T defaultValue, Class<T> pType, Type pGenericType, Annotation secondaryOption) throws InvalidConfigurationException {
        this.checkApplicability(pType, secondaryOption, optionName);
        FileOption.Type typeInfo = ((FileOption)secondaryOption).value();
        if (defaultValue == null) {
            if (typeInfo == FileOption.Type.REQUIRED_INPUT_FILE) {
                throw new UnsupportedOperationException("The option " + optionName + " specifies a required input file, but the option is neither required nor has a default value.");
            }
            return null;
        }
        if (this.disableOutput && typeInfo == FileOption.Type.OUTPUT_FILE) {
            return null;
        }
        File value = this.handleFileOption(optionName, (File)defaultValue, typeInfo);
        return (T)value;
    }

    private File handleFileOption(String optionName, File file, FileOption.Type typeInfo) throws InvalidConfigurationException {
        if (typeInfo == FileOption.Type.OUTPUT_FILE && !file.isAbsolute()) {
            file = new File(this.outputDirectory, file.getPath());
        }
        if (!file.isAbsolute()) {
            file = new File(this.rootDirectory, file.getPath());
        }
        if (file.isDirectory()) {
            throw new InvalidConfigurationException("Option " + optionName + " needs to specify a file and not a directory");
        }
        if (typeInfo == FileOption.Type.REQUIRED_INPUT_FILE) {
            try {
                Files.checkReadableFile(file);
            }
            catch (FileNotFoundException e) {
                throw new InvalidConfigurationException("Option " + optionName + " specifies an invalid input file: " + e.getMessage(), e);
            }
        }
        return file;
    }
}

