/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration.converters;

import com.google.common.base.CharMatcher;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.configuration.converters.TypeConverter;

public class TimeSpanTypeConverter
implements TypeConverter {
    private static final BiMap<String, TimeUnit> TIME_UNITS = ImmutableBiMap.of((Object)"ns", (Object)((Object)TimeUnit.NANOSECONDS), (Object)"ms", (Object)((Object)TimeUnit.MILLISECONDS), (Object)"s", (Object)((Object)TimeUnit.SECONDS), (Object)"min", (Object)((Object)TimeUnit.MINUTES), (Object)"h", (Object)((Object)TimeUnit.HOURS));

    @Override
    public Object convert(String optionName, String valueStr, Class<?> pType, Type pGenericType, Annotation pOption) throws InvalidConfigurationException {
        Number result;
        int i;
        if (!(pOption instanceof TimeSpanOption)) {
            throw new UnsupportedOperationException("Time span options need to be annotated with @TimeSpanOption");
        }
        TimeSpanOption option = (TimeSpanOption)pOption;
        CharMatcher letterMatcher = CharMatcher.JAVA_LETTER;
        for (i = valueStr.length() - 1; i >= 0 && letterMatcher.matches(valueStr.charAt(i)); --i) {
        }
        if (i < 0) {
            throw new InvalidConfigurationException("Option " + optionName + " contains no number");
        }
        TimeUnit userUnit = (TimeUnit)((Object)TIME_UNITS.get((Object)valueStr.substring(i + 1)));
        if (userUnit == null) {
            userUnit = option.defaultUserUnit();
        }
        long value = Long.parseLong(valueStr.substring(0, i + 1).trim());
        TimeUnit codeUnit = option.codeUnit();
        value = codeUnit.convert(value, userUnit);
        if (option.min() > value || value > option.max()) {
            String codeUnitStr = (String)TIME_UNITS.inverse().get((Object)codeUnit);
            throw new InvalidConfigurationException(String.format("Invalid value in configuration file: \"%s = %s (not in range [%d %s, %d %s])", optionName, value, option.min(), codeUnitStr, option.max(), codeUnitStr));
        }
        if (pType.equals(Integer.class)) {
            if (value > Integer.MAX_VALUE) {
                throw new InvalidConfigurationException("Value for option " + optionName + " is larger than " + Integer.MAX_VALUE);
            }
            result = (int)value;
        } else {
            result = value;
        }
        return result;
    }

    @Override
    public <T> T convertDefaultValue(String pOptionName, T pValue, Class<T> pType, Type pGenericType, Annotation pSecondaryOption) {
        return pValue;
    }
}

