/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CFACheck {
    private static final Function<CFANode, String> DEBUG_FORMAT = new Function<CFANode, String>(){

        public String apply(CFANode node) {
            if (node == null) {
                return "NULL";
            }
            FileLocation location = FileLocation.DUMMY;
            if (node.getNumEnteringEdges() > 0) {
                location = node.getEnteringEdge(0).getFileLocation();
            } else if (node.getNumLeavingEdges() > 0) {
                location = node.getLeavingEdge(0).getFileLocation();
            }
            return node.getFunctionName() + ":" + node + " (" + location + ")";
        }
    };

    public static boolean check(FunctionEntryNode cfa, Collection<CFANode> nodes, boolean pruned) {
        HashSet<CFANode> visitedNodes = new HashSet<CFANode>();
        ArrayDeque<FunctionEntryNode> waitingNodeList = new ArrayDeque<FunctionEntryNode>();
        waitingNodeList.add(cfa);
        while (!waitingNodeList.isEmpty()) {
            CFANode node = (CFANode)waitingNodeList.poll();
            if (!visitedNodes.add(node)) continue;
            Iterables.addAll(waitingNodeList, CFAUtils.successorsOf(node));
            Iterables.addAll(waitingNodeList, CFAUtils.predecessorsOf(node));
            CFACheck.isConsistent(node);
            CFACheck.checkEdgeCount(node, pruned);
        }
        if (nodes != null && !visitedNodes.equals(nodes)) assert (false) : "\nNodes in CFA but not reachable through traversal: " + Iterables.transform((Iterable)Sets.difference(new HashSet<CFANode>(nodes), visitedNodes), DEBUG_FORMAT) + "\nNodes reached that are not in CFA: " + Iterables.transform((Iterable)Sets.difference(visitedNodes, new HashSet<CFANode>(nodes)), DEBUG_FORMAT);
        return true;
    }

    private static void checkEdgeCount(CFANode pNode, boolean pruned) {
        int entering = pNode.getNumEnteringEdges();
        if (entering == 0) assert (pNode instanceof FunctionEntryNode) : "Dead code: node " + (String)DEBUG_FORMAT.apply((Object)pNode) + " has no incoming edges (successors are " + CFAUtils.successorsOf(pNode).transform(DEBUG_FORMAT) + ")";
        if (!(pNode instanceof FunctionExitNode)) {
            switch (pNode.getNumLeavingEdges()) {
                case 0: {
                    if (!pruned) assert (pNode instanceof CFATerminationNode) : "Dead end at node " + (String)DEBUG_FORMAT.apply((Object)pNode);
                    break;
                }
                case 1: {
                    CFAEdge edge = pNode.getLeavingEdge(0);
                    if (!pruned) assert (!(edge instanceof AssumeEdge)) : "AssumeEdge does not appear in pair at node " + (String)DEBUG_FORMAT.apply((Object)pNode);
                    assert (!(edge instanceof CFunctionSummaryStatementEdge)) : "CFunctionSummaryStatementEdge is not paired with CFunctionCallEdge at node " + (String)DEBUG_FORMAT.apply((Object)pNode);
                    break;
                }
                case 2: {
                    CFAEdge edge1 = pNode.getLeavingEdge(0);
                    CFAEdge edge2 = pNode.getLeavingEdge(1);
                    if (edge1 instanceof CFunctionSummaryStatementEdge) {
                        assert (edge2 instanceof CFunctionCallEdge) : "CFunctionSummaryStatementEdge is not paired with CFunctionCallEdge at node " + (String)DEBUG_FORMAT.apply((Object)pNode);
                        break;
                    }
                    if (edge2 instanceof CFunctionSummaryStatementEdge) {
                        assert (edge1 instanceof CFunctionCallEdge) : "CFunctionSummaryStatementEdge is not paired with CFunctionCallEdge at node " + (String)DEBUG_FORMAT.apply((Object)pNode);
                        break;
                    }
                    assert (edge1 instanceof AssumeEdge && edge2 instanceof AssumeEdge) : "Branching without conditions at node " + (String)DEBUG_FORMAT.apply((Object)pNode);
                    AssumeEdge ae1 = (AssumeEdge)edge1;
                    AssumeEdge ae2 = (AssumeEdge)edge2;
                    assert (ae1.getTruthAssumption() != ae2.getTruthAssumption()) : "Inconsistent branching at node " + (String)DEBUG_FORMAT.apply((Object)pNode);
                    break;
                }
                default: {
                    assert (false) : "Too much branching at node " + (String)DEBUG_FORMAT.apply((Object)pNode);
                    break;
                }
            }
        }
    }

    private static void isConsistent(CFANode pNode) {
        boolean hasEdge;
        HashSet<CFAEdge> seenEdges = new HashSet<CFAEdge>();
        HashSet<CFANode> seenNodes = new HashSet<CFANode>();
        for (CFAEdge edge : CFAUtils.leavingEdges(pNode)) {
            if (!seenEdges.add(edge)) assert (false) : "Duplicate leaving edge " + edge + " on node " + (String)DEBUG_FORMAT.apply((Object)pNode);
            CFANode successor = edge.getSuccessor();
            if (!seenNodes.add(successor)) assert (false) : "Duplicate successor " + successor + " for node " + (String)DEBUG_FORMAT.apply((Object)pNode);
            hasEdge = CFAUtils.enteringEdges(successor).contains((Object)edge);
            assert (hasEdge) : "Node " + (String)DEBUG_FORMAT.apply((Object)pNode) + " has leaving edge " + edge + ", but pNode " + (String)DEBUG_FORMAT.apply((Object)successor) + " does not have this edge as entering edge!";
        }
        seenEdges.clear();
        seenNodes.clear();
        for (CFAEdge edge : CFAUtils.enteringEdges(pNode)) {
            if (!seenEdges.add(edge)) assert (false) : "Duplicate entering edge " + edge + " on node " + (String)DEBUG_FORMAT.apply((Object)pNode);
            CFANode predecessor = edge.getPredecessor();
            if (!seenNodes.add(predecessor)) assert (false) : "Duplicate predecessor " + predecessor + " for node " + (String)DEBUG_FORMAT.apply((Object)pNode);
            hasEdge = CFAUtils.leavingEdges(predecessor).contains((Object)edge);
            assert (hasEdge) : "Node " + (String)DEBUG_FORMAT.apply((Object)pNode) + " has entering edge " + edge + ", but pNode " + (String)DEBUG_FORMAT.apply((Object)pNode) + " does not have this edge as leaving edge!";
        }
    }
}

