/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.io.FileWriteMode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.concurrency.Threads;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACheck;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.CFAReversePostorder;
import org.sosy_lab.cpachecker.cfa.CFASecondPassBuilder;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CParserWithLocationMapper;
import org.sosy_lab.cpachecker.cfa.CParserWithPreprocessor;
import org.sosy_lab.cpachecker.cfa.CPreprocessor;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ImmutableCFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.Parser;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JDeclaration;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder2;
import org.sosy_lab.cpachecker.cfa.export.FunctionCallDumper;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.EclipseParsers;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.CFADeclarationMover;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.CFASimplifier;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.CFunctionPointerResolver;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.ExpandFunctionPointerArrayAssignments;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.MultiEdgeCreator;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.NullPointerChecks;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.CFAReduction;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.FunctionCallUnwinder;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.singleloop.CFASingleLoopTransformation;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CDefaults;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CParserException;
import org.sosy_lab.cpachecker.exceptions.JParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.VariableClassification;
import org.sosy_lab.cpachecker.util.VariableClassificationBuilder;

@Options
public class CFACreator {
    private static final String JAVA_MAIN_METHOD_CFA_SUFFIX = "_main_String[]";
    public static final String VALID_C_FUNCTION_NAME_PATTERN = "[_a-zA-Z][_a-zA-Z0-9]*";
    @Option(secure=true, name="parser.usePreprocessor", description="For C files, run the preprocessor on them before parsing. Note that all file numbers printed by CPAchecker will refer to the pre-processed file, not the original input file.")
    private boolean usePreprocessor = false;
    @Option(secure=true, name="parser.readLineDirectives", description="For C files, read #line preprocessor directives and use their information for outputting line numbers. (Always enabled when pre-processing is used.)")
    private boolean readLineDirectives = false;
    @Option(secure=true, name="analysis.entryFunction", regexp="^[_a-zA-Z][_a-zA-Z0-9]*$", description="entry function")
    private String mainFunctionName = "main";
    @Option(secure=true, name="analysis.machineModel", description="the machine model, which determines the sizes of types like int")
    private MachineModel machineModel = MachineModel.LINUX32;
    @Option(secure=true, name="analysis.interprocedural", description="run interprocedural analysis")
    private boolean interprocedural = true;
    @Option(secure=true, name="analysis.functionPointerCalls", description="create all potential function pointer call edges")
    private boolean fptrCallEdges = true;
    @Option(secure=true, name="analysis.useGlobalVars", description="add declarations for global variables before entry function")
    private boolean useGlobalVars = true;
    @Option(secure=true, name="cfa.useMultiEdges", description="combine sequences of simple edges into a single edge")
    private boolean useMultiEdges = false;
    @Option(secure=true, name="cfa.removeIrrelevantForSpecification", description="remove paths from CFA that cannot lead to a specification violation")
    private boolean removeIrrelevantForSpecification = false;
    @Option(secure=true, name="cfa.export", description="export CFA as .dot file")
    private boolean exportCfa = true;
    @Option(secure=true, name="cfa.exportPerFunction", description="export individual CFAs for function as .dot files")
    private boolean exportCfaPerFunction = true;
    @Option(secure=true, name="cfa.callgraph.export", description="dump a simple call graph")
    private boolean exportFunctionCalls = true;
    @Option(secure=true, name="cfa.callgraph.file", description="file name for call graph as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportFunctionCallsFile = Paths.get((String)"functionCalls.dot", (String[])new String[0]);
    @Option(secure=true, name="cfa.file", description="export CFA as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportCfaFile = Paths.get((String)"cfa.dot", (String[])new String[0]);
    @Option(secure=true, name="cfa.checkNullPointers", description="while this option is activated, before each use of a PointerExpression, or a dereferenced field access the expression is checked if it is 0")
    private boolean checkNullPointers = false;
    @Option(secure=true, name="cfa.expandFunctionPointerArrayAssignments", description="When a function pointer array element is written with a variable as index, create a series of if-else edges with explicit indizes instead.")
    private boolean expandFunctionPointerArrayAssignments = false;
    @Option(secure=true, name="cfa.transformIntoSingleLoop", description="This option causes the control flow automaton to be transformed into the automaton of an equivalent program with one single loop and an artificial program counter.")
    private boolean transformIntoSingleLoop = false;
    @Option(secure=true, name="cfa.simplifyCfa", description="Remove all edges which don't have any effect on the program")
    private boolean simplifyCfa = true;
    @Option(secure=true, name="cfa.moveDeclarationsToFunctionStart", description="With this option, all declarations in each function will be movedto the beginning of each function. Do only use this option if you arenot able to handle initializer lists and designated initializers (like they can be used for arrays and structs) in your analysis anyway. this option will otherwise create c code which is not the same as the original one")
    private boolean moveDeclarationsToFunctionStart = false;
    @Option(secure=true, name="cfa.useFunctionCallUnwinding", description="unwind recursive functioncalls (bounded to max call stack size)")
    private boolean useFunctionCallUnwinding = false;
    @Option(secure=true, name="cfa.findLiveVariables", description="By enabling this option the variables that are live are computed for each edge of the cfa. Live means that their value is read later on.")
    private boolean findLiveVariables = false;
    @Option(secure=true, name="cfa.classifyNodes", description="This option enables the computation of a classification of CFA nodes.")
    private boolean classifyNodes = false;
    @Option(secure=true, description="C or Java?")
    private Language language = Language.C;
    private final LogManager logger;
    private final Parser parser;
    private final CFAReduction cfaReduction;
    private final ShutdownNotifier shutdownNotifier;
    private final CFACreatorStatistics stats = new CFACreatorStatistics();
    private final Configuration config;

    public CFACreator(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.config = config;
        this.logger = logger;
        this.shutdownNotifier = pShutdownNotifier;
        this.stats.parserInstantiationTime.start();
        switch (this.language) {
            case JAVA: {
                this.parser = EclipseParsers.getJavaParser(logger, config);
                break;
            }
            case C: {
                CParser outerParser = CParser.Factory.getParser(config, logger, CParser.Factory.getOptions(config), this.machineModel);
                outerParser = new CParserWithLocationMapper(config, logger, outerParser, this.readLineDirectives || this.usePreprocessor);
                if (this.usePreprocessor) {
                    CPreprocessor preprocessor = new CPreprocessor(config, logger);
                    outerParser = new CParserWithPreprocessor(outerParser, preprocessor);
                }
                this.parser = outerParser;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.stats.parsingTime = this.parser.getParseTime();
        this.stats.conversionTime = this.parser.getCFAConstructionTime();
        this.cfaReduction = this.removeIrrelevantForSpecification ? new CFAReduction(config, logger, pShutdownNotifier) : null;
        this.stats.parserInstantiationTime.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFA parseFileAndCreateCFA(String program) throws InvalidConfigurationException, IOException, ParserException, InterruptedException {
        this.stats.totalTime.start();
        try {
            CFA cfa;
            ParseResult parseResult = this.parseToCFAs(program);
            FunctionEntryNode mainFunction = (FunctionEntryNode)parseResult.getFunctions().get(this.mainFunctionName);
            assert (mainFunction != null) : "program lacks main function.";
            CFA cFA = cfa = this.createCFA(parseResult, mainFunction);
            return cFA;
        }
        finally {
            this.stats.totalTime.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFA parseFileAndCreateCFA(List<String> sourceFiles) throws InvalidConfigurationException, IOException, ParserException, InterruptedException {
        Preconditions.checkArgument((!sourceFiles.isEmpty() ? 1 : 0) != 0, (Object)"At least one source file must be provided!");
        this.stats.totalTime.start();
        try {
            FunctionEntryNode mainFunction;
            this.logger.log(Level.FINE, new Object[]{"Starting parsing of file(s)"});
            ParseResult c = this.parseToCFAs(sourceFiles);
            this.logger.log(Level.FINE, new Object[]{"Parser Finished"});
            switch (this.language) {
                case JAVA: {
                    mainFunction = this.getJavaMainMethod(sourceFiles, c.getFunctions());
                    break;
                }
                case C: {
                    mainFunction = this.getCMainFunction(sourceFiles, c.getFunctions());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            CFA cFA = this.createCFA(c, mainFunction);
            return cFA;
        }
        finally {
            this.stats.totalTime.stop();
        }
    }

    private CFA createCFA(ParseResult pParseResult, FunctionEntryNode pMainFunction) throws InvalidConfigurationException, InterruptedException, ParserException {
        Optional varClassification;
        FunctionEntryNode mainFunction = pMainFunction;
        assert (mainFunction != null);
        MutableCFA cfa = new MutableCFA(this.machineModel, pParseResult.getFunctions(), pParseResult.getCFANodes(), mainFunction, this.language);
        this.stats.checkTime.start();
        for (String functionName : cfa.getAllFunctionNames()) {
            assert (CFACheck.check(cfa.getFunctionHead(functionName), cfa.getFunctionNodes(functionName), false));
        }
        this.stats.checkTime.stop();
        this.stats.processingTime.start();
        cfa = this.postProcessingOnMutableCFAs(cfa, pParseResult.getGlobalDeclarations());
        this.stats.checkTime.start();
        for (String functionName : cfa.getAllFunctionNames()) {
            assert (CFACheck.check(cfa.getFunctionHead(functionName), cfa.getFunctionNodes(functionName), false));
        }
        this.stats.checkTime.stop();
        for (FunctionEntryNode function : cfa.getAllFunctionHeads()) {
            CFAReversePostorder sorter = new CFAReversePostorder();
            sorter.assignSorting(function);
        }
        Optional<LoopStructure> loopStructure = this.getLoopStructure(cfa);
        cfa.setLoopStructure(loopStructure);
        if (this.interprocedural) {
            this.logger.log(Level.FINE, new Object[]{"Analysis is interprocedural, adding super edges."});
            CFASecondPassBuilder spbuilder = new CFASecondPassBuilder(cfa, this.language, this.logger, this.config);
            spbuilder.insertCallEdgesRecursively();
        }
        if (this.cfaReduction != null) {
            this.stats.pruningTime.start();
            this.cfaReduction.removeIrrelevantForSpecification(cfa);
            this.stats.pruningTime.stop();
            if (cfa.isEmpty()) {
                this.logger.log(Level.INFO, new Object[]{"No states which violate the specification are syntactically reachable from the function " + mainFunction.getFunctionName() + ", analysis not necessary. " + "If you want to run the analysis anyway, set the option cfa.removeIrrelevantForSpecification to false."});
                return ImmutableCFA.empty(this.machineModel, this.language);
            }
        }
        if (this.transformIntoSingleLoop) {
            cfa = CFASingleLoopTransformation.getSingleLoopTransformation(this.logger, this.config, this.shutdownNotifier).apply(cfa);
            mainFunction = cfa.getMainFunction();
        }
        if (this.language == Language.C) {
            try {
                this.stats.variableClassificationTime.start();
                varClassification = Optional.of((Object)new VariableClassificationBuilder(this.config, this.logger).build(cfa));
            }
            catch (UnrecognizedCCodeException e) {
                throw new CParserException(e);
            }
            finally {
                this.stats.variableClassificationTime.stop();
            }
        } else {
            varClassification = Optional.absent();
        }
        if (this.findLiveVariables && (varClassification.isPresent() || cfa.getLanguage() != Language.C)) {
            cfa.setLiveVariables(LiveVariables.create((Optional<VariableClassification>)varClassification, pParseResult.getGlobalDeclarations(), cfa, this.logger, this.shutdownNotifier, this.config));
        }
        this.stats.processingTime.stop();
        ImmutableCFA immutableCFA = cfa.makeImmutableCFA((Optional<VariableClassification>)varClassification);
        this.stats.checkTime.start();
        assert (CFACheck.check(mainFunction, null, this.cfaReduction != null));
        this.stats.checkTime.stop();
        if (this.exportCfaFile != null && (this.exportCfa || this.exportCfaPerFunction) || this.exportFunctionCallsFile != null && this.exportFunctionCalls) {
            this.exportCFAAsync(immutableCFA);
        }
        this.logger.log(Level.FINE, new Object[]{"DONE, CFA for", immutableCFA.getNumberOfFunctions(), "functions created."});
        return immutableCFA;
    }

    private ParseResult parseToCFAs(String program) throws InvalidConfigurationException, IOException, ParserException, InterruptedException {
        CSourceOriginMapping sourceOriginMapping = new CSourceOriginMapping();
        ParseResult parseResult = this.parser.parseString("test", program, sourceOriginMapping);
        if (parseResult.isEmpty()) {
            switch (this.language) {
                case JAVA: {
                    throw new JParserException("No methods found in program");
                }
                case C: {
                    throw new CParserException("No functions found in program");
                }
            }
            throw new AssertionError();
        }
        return parseResult;
    }

    private ParseResult parseToCFAs(List<String> sourceFiles) throws InvalidConfigurationException, IOException, ParserException, InterruptedException {
        ParseResult parseResult;
        if (this.language == Language.C) {
            this.checkIfValidFiles(sourceFiles);
        }
        CSourceOriginMapping sourceOriginMapping = new CSourceOriginMapping();
        if (sourceFiles.size() == 1) {
            parseResult = this.parser.parseFile(sourceFiles.get(0), sourceOriginMapping);
        } else {
            if (this.language != Language.C) {
                throw new InvalidConfigurationException("Multiple program files not supported for languages other than C.");
            }
            ArrayList<CParser.FileToParse> programFragments = new ArrayList<CParser.FileToParse>();
            for (String fileName : sourceFiles) {
                programFragments.add(new CParser.FileToParse(fileName));
            }
            parseResult = ((CParser)this.parser).parseFile(programFragments, sourceOriginMapping);
        }
        if (parseResult.isEmpty()) {
            switch (this.language) {
                case JAVA: {
                    throw new JParserException("No methods found in program");
                }
                case C: {
                    throw new CParserException("No functions found in program");
                }
            }
            throw new AssertionError();
        }
        return parseResult;
    }

    private MutableCFA postProcessingOnMutableCFAs(MutableCFA cfa, List<Pair<ADeclaration, String>> globalDeclarations) throws InvalidConfigurationException, CParserException {
        if (this.simplifyCfa) {
            CFASimplifier.simplifyCFA(cfa);
        }
        if (this.moveDeclarationsToFunctionStart) {
            CFADeclarationMover declarationMover = new CFADeclarationMover(this.logger);
            declarationMover.moveDeclarationsToFunctionStart(cfa);
        }
        if (this.checkNullPointers) {
            NullPointerChecks nullPointerCheck = new NullPointerChecks(this.logger, this.config);
            nullPointerCheck.addNullPointerChecks(cfa);
        }
        if (this.expandFunctionPointerArrayAssignments) {
            ExpandFunctionPointerArrayAssignments transformer = new ExpandFunctionPointerArrayAssignments(this.logger, this.config);
            transformer.replaceFunctionPointerArrayAssignments(cfa);
        }
        if (this.language == Language.C && this.fptrCallEdges) {
            CFunctionPointerResolver fptrResolver = new CFunctionPointerResolver(cfa, globalDeclarations, this.config, this.logger);
            fptrResolver.resolveFunctionPointers();
        }
        ArrayList<CFATerminationNode> toAdd = new ArrayList<CFATerminationNode>(1);
        for (CFANode cFANode : cfa.getAllNodes()) {
            HashSet<CFANode> visited = new HashSet<CFANode>();
            ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
            waitlist.offer(cFANode);
            visited.add(cFANode);
            while (!waitlist.isEmpty()) {
                CFANode current = (CFANode)waitlist.poll();
                for (CFAEdge leavingBlankEdge : CFAUtils.leavingEdges(current).filter(BlankEdge.class).toList()) {
                    CFANode succ = leavingBlankEdge.getSuccessor();
                    if (succ == cFANode && succ.getNumEnteringEdges() > 1) {
                        leavingBlankEdge.getPredecessor().removeLeavingEdge(leavingBlankEdge);
                        leavingBlankEdge.getSuccessor().removeEnteringEdge(leavingBlankEdge);
                        CFATerminationNode terminationNode = new CFATerminationNode(cFANode.getFunctionName());
                        BlankEdge terminationEdge = new BlankEdge(leavingBlankEdge.getRawStatement(), leavingBlankEdge.getFileLocation(), leavingBlankEdge.getPredecessor(), terminationNode, leavingBlankEdge.getDescription());
                        terminationEdge.getPredecessor().addLeavingEdge(terminationEdge);
                        terminationEdge.getSuccessor().addEnteringEdge(terminationEdge);
                        toAdd.add(terminationNode);
                    }
                    if (!visited.add(succ)) continue;
                    waitlist.offer(succ);
                }
            }
        }
        for (CFANode cFANode : toAdd) {
            cfa.addNode(cFANode);
        }
        if (this.useFunctionCallUnwinding) {
            FunctionCallUnwinder fca = new FunctionCallUnwinder(cfa, this.config, this.logger);
            cfa = fca.unwindRecursion();
        }
        if (this.useGlobalVars) {
            this.insertGlobalDeclarations(cfa, globalDeclarations);
        }
        if (this.useMultiEdges) {
            MultiEdgeCreator.createMultiEdges(cfa);
        }
        return cfa;
    }

    private FunctionEntryNode getJavaMainMethod(List<String> sourceFiles, Map<String, FunctionEntryNode> cfas) throws InvalidConfigurationException {
        Preconditions.checkArgument((sourceFiles.size() == 1 ? 1 : 0) != 0, (Object)"Multiple input files not supported by 'getJavaMainMethod'");
        String mainClassName = sourceFiles.get(0);
        FunctionEntryNode mainFunction = cfas.get(this.mainFunctionName);
        if (mainFunction != null) {
            return mainFunction;
        }
        if (!this.mainFunctionName.equals("main")) {
            throw new InvalidConfigurationException("Method " + this.mainFunctionName + " not found.\n" + "Please note that a method has to be given in the following notation:\n <ClassName>_" + "<MethodName>_<ParameterTypes>.\nExample: pack1.Car_drive_int_pack1.Car\n" + "for the method drive(int speed, Car car) in the class Car.");
        }
        mainFunction = cfas.get(mainClassName + JAVA_MAIN_METHOD_CFA_SUFFIX);
        if (mainFunction == null) {
            throw new InvalidConfigurationException("No main method in given main class found, please specify one.");
        }
        return mainFunction;
    }

    private void checkIfValidFiles(List<String> sourceFiles) throws InvalidConfigurationException {
        for (String file : sourceFiles) {
            this.checkIfValidFile(file);
        }
    }

    private void checkIfValidFile(String fileDenotation) throws InvalidConfigurationException {
        Path file = Paths.get((String)fileDenotation, (String[])new String[0]);
        try {
            Files.checkReadableFile((Path)file);
        }
        catch (FileNotFoundException e) {
            throw new InvalidConfigurationException(e.getMessage());
        }
    }

    private FunctionEntryNode getCMainFunction(List<String> sourceFiles, Map<String, FunctionEntryNode> cfas) throws InvalidConfigurationException {
        FunctionEntryNode mainFunction = cfas.get(this.mainFunctionName);
        if (mainFunction != null) {
            return mainFunction;
        }
        if (!this.mainFunctionName.equals("main")) {
            throw new InvalidConfigurationException("Function " + this.mainFunctionName + " not found.");
        }
        if (cfas.size() == 1) {
            return (FunctionEntryNode)Iterables.getOnlyElement(cfas.values());
        }
        if (sourceFiles.size() == 1) {
            String filename = sourceFiles.get(0);
            int indexOfDot = (filename = Paths.get((String)filename, (String[])new String[0]).getName()).indexOf(46);
            String baseFilename = indexOfDot >= 1 ? filename.substring(0, indexOfDot) : filename;
            mainFunction = cfas.get(baseFilename);
        }
        if (mainFunction == null) {
            throw new InvalidConfigurationException("No entry function found, please specify one.");
        }
        return mainFunction;
    }

    private Optional<LoopStructure> getLoopStructure(MutableCFA cfa) {
        try {
            return Optional.of((Object)LoopStructure.getLoopStructure(cfa));
        }
        catch (ParserException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not analyze loop structure of program.");
        }
        catch (OutOfMemoryError e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not analyze loop structure of program due to memory problems");
        }
        return Optional.absent();
    }

    private void insertGlobalDeclarations(MutableCFA cfa, List<Pair<ADeclaration, String>> globalVars) {
        if (globalVars.isEmpty()) {
            return;
        }
        if (cfa.getLanguage() == Language.C) {
            CFACreator.addDefaultInitializers(globalVars);
        }
        FunctionEntryNode firstNode = cfa.getMainFunction();
        assert (firstNode.getNumLeavingEdges() == 1);
        CFAEdge firstEdge = firstNode.getLeavingEdge(0);
        assert (firstEdge.getEdgeType() == CFAEdgeType.BlankEdge);
        CFANode secondNode = firstEdge.getSuccessor();
        CFACreationUtils.removeEdgeFromNodes(firstEdge);
        CFANode cur = new CFANode(firstNode.getFunctionName());
        cfa.addNode(cur);
        BlankEdge newFirstEdge = new BlankEdge("", FileLocation.DUMMY, firstNode, cur, "INIT GLOBAL VARS");
        CFACreationUtils.addEdgeUnconditionallyToCFA(newFirstEdge);
        for (Pair<ADeclaration, String> p : globalVars) {
            ADeclarationEdge newEdge;
            ADeclaration d = (ADeclaration)p.getFirst();
            String rawSignature = (String)p.getSecond();
            assert (d.isGlobal());
            CFANode n = new CFANode(cur.getFunctionName());
            cfa.addNode(n);
            switch (cfa.getLanguage()) {
                case C: {
                    newEdge = new CDeclarationEdge(rawSignature, d.getFileLocation(), cur, n, (CDeclaration)d);
                    break;
                }
                case JAVA: {
                    newEdge = new JDeclarationEdge(rawSignature, d.getFileLocation(), cur, n, (JDeclaration)d);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unknown language");
                }
            }
            CFACreationUtils.addEdgeUnconditionallyToCFA(newEdge);
            cur = n;
        }
        BlankEdge newLastEdge = new BlankEdge(firstEdge.getRawStatement(), firstEdge.getFileLocation(), cur, secondNode, firstEdge.getDescription());
        CFACreationUtils.addEdgeUnconditionallyToCFA(newLastEdge);
    }

    private static void addDefaultInitializers(List<Pair<ADeclaration, String>> globalVars) {
        HashSet<String> initializedVariables = new HashSet<String>();
        for (Pair<ADeclaration, String> p : globalVars) {
            AVariableDeclaration v;
            if (!(p.getFirst() instanceof AVariableDeclaration) || (v = (AVariableDeclaration)p.getFirst()).getInitializer() == null) continue;
            initializedVariables.add(v.getName());
        }
        HashSet<String> previouslyInitializedVariables = new HashSet<String>();
        ListIterator<Pair<ADeclaration, String>> iterator = globalVars.listIterator();
        while (iterator.hasNext()) {
            CType type;
            Pair<ADeclaration, String> p = iterator.next();
            if (!(p.getFirst() instanceof AVariableDeclaration)) continue;
            CVariableDeclaration v = (CVariableDeclaration)p.getFirst();
            assert (v.isGlobal());
            String name = v.getName();
            if (previouslyInitializedVariables.contains(name)) {
                iterator.remove();
                continue;
            }
            if (v.getInitializer() != null) {
                previouslyInitializedVariables.add(name);
                continue;
            }
            if (initializedVariables.contains(name) || v.getCStorageClass() != CStorageClass.AUTO || (type = v.getType().getCanonicalType()) instanceof CElaboratedType && ((CElaboratedType)type).getKind() != CComplexType.ComplexTypeKind.ENUM) continue;
            CInitializer initializer = CDefaults.forType(type, v.getFileLocation());
            v = new CVariableDeclaration(v.getFileLocation(), v.isGlobal(), v.getCStorageClass(), v.getType(), v.getName(), v.getOrigName(), v.getQualifiedName(), initializer);
            previouslyInitializedVariables.add(name);
            iterator.set((Pair<ADeclaration, String>)Pair.of((Object)v, (Object)p.getSecond()));
        }
    }

    private void exportCFAAsync(final CFA cfa) {
        Threads.newThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CFACreator.this.exportCFA(cfa);
            }
        }, (String)"CFA export thread").start();
    }

    private void exportCFA(CFA cfa) {
        Throwable throwable;
        Writer w;
        this.stats.exportTime.start();
        if (this.exportCfa && this.exportCfaFile != null) {
            try {
                w = Files.openOutputFile((Path)this.exportCfaFile, (FileWriteMode[])new FileWriteMode[0]);
                throwable = null;
                try {
                    DOTBuilder.generateDOT(w, cfa);
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (w != null) {
                        if (throwable != null) {
                            try {
                                w.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            w.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write CFA to dot file");
            }
        }
        if (this.exportCfaPerFunction && this.exportCfaFile != null) {
            try {
                Path outdir = this.exportCfaFile.getParent();
                DOTBuilder2.writeReport(cfa, outdir);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write CFA to dot and json file");
            }
        }
        if (this.exportFunctionCalls && this.exportFunctionCallsFile != null) {
            try {
                w = Files.openOutputFile((Path)this.exportFunctionCallsFile, (FileWriteMode[])new FileWriteMode[0]);
                throwable = null;
                try {
                    FunctionCallDumper.dump(w, cfa);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (w != null) {
                        if (throwable != null) {
                            try {
                                w.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            w.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write functionCalls to dot file");
            }
        }
        this.stats.exportTime.stop();
    }

    public CFACreatorStatistics getStatistics() {
        return this.stats;
    }

    private static class CFACreatorStatistics
    implements Statistics {
        private final Timer parserInstantiationTime = new Timer();
        private final Timer totalTime = new Timer();
        private Timer parsingTime;
        private Timer conversionTime;
        private final Timer checkTime = new Timer();
        private final Timer processingTime = new Timer();
        private final Timer pruningTime = new Timer();
        private final Timer variableClassificationTime = new Timer();
        private final Timer exportTime = new Timer();

        private CFACreatorStatistics() {
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            out.println("  Time for loading parser:    " + this.parserInstantiationTime);
            out.println("  Time for CFA construction:  " + this.totalTime);
            out.println("    Time for parsing file(s): " + this.parsingTime);
            out.println("    Time for AST to CFA:      " + this.conversionTime);
            out.println("    Time for CFA sanity check:" + this.checkTime);
            out.println("    Time for post-processing: " + this.processingTime);
            if (this.pruningTime.getNumberOfIntervals() > 0) {
                out.println("      Time for CFA pruning:   " + this.pruningTime);
            }
            if (this.variableClassificationTime.getNumberOfIntervals() > 0) {
                out.println("      Time for var class.:    " + this.pruningTime);
            }
            if (this.exportTime.getNumberOfIntervals() > 0) {
                out.println("    Time for CFA export:      " + this.exportTime);
            }
        }
    }
}

