/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CFAReversePostorder {
    private int reversePostorderId = 0;
    private final Set<CFANode> visited = new HashSet<CFANode>();
    private int reversePostorderId2 = 0;

    private boolean checkIds(CFANode node) {
        if (!this.visited.add(node)) {
            return true;
        }
        for (CFANode successor : CFAUtils.successorsOf(node)) {
            this.checkIds(successor);
        }
        assert (node.getReversePostorderId() == this.reversePostorderId2++) : "Node " + node + " got " + node.getReversePostorderId() + ", but should get " + (this.reversePostorderId2 - 1);
        return true;
    }

    public void assignSorting(CFANode start) {
        HashSet<CFANode> visited = new HashSet<CFANode>();
        ArrayDeque<CFANode> nodeStack = new ArrayDeque<CFANode>();
        LinkedList<Iterator> iteratorStack = new LinkedList<Iterator>();
        nodeStack.push(start);
        iteratorStack.push(null);
        while (!nodeStack.isEmpty()) {
            assert (nodeStack.size() == iteratorStack.size());
            CFANode node = (CFANode)nodeStack.peek();
            Iterator successors = (Iterator)iteratorStack.peek();
            if (successors == null) {
                if (!visited.add(node)) {
                    nodeStack.pop();
                    iteratorStack.pop();
                    continue;
                }
                successors = CFAUtils.successorsOf(node).iterator();
                iteratorStack.pop();
                iteratorStack.push(successors);
            }
            if (successors.hasNext()) {
                CFANode successor = (CFANode)successors.next();
                nodeStack.push(successor);
                iteratorStack.push(null);
                continue;
            }
            node.setReversePostorderId(this.reversePostorderId++);
            nodeStack.pop();
            iteratorStack.pop();
        }
    }
}

