/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.io.IOException;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.Parser;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.EclipseParsers;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.exceptions.CParserException;

public interface CParser
extends Parser {
    public ParseResult parseFile(List<FileToParse> var1, CSourceOriginMapping var2) throws CParserException, IOException, InvalidConfigurationException, InterruptedException;

    public ParseResult parseString(List<FileContentToParse> var1, CSourceOriginMapping var2) throws CParserException, InvalidConfigurationException;

    public CAstNode parseSingleStatement(String var1, Scope var2) throws CParserException, InvalidConfigurationException;

    public List<CAstNode> parseStatements(String var1, Scope var2) throws CParserException, InvalidConfigurationException;

    public static class Factory {
        public static ParserOptions getOptions(Configuration config) throws InvalidConfigurationException {
            ParserOptions result = new ParserOptions();
            config.inject((Object)result);
            return result;
        }

        public static ParserOptions getDefaultOptions() {
            return new ParserOptions();
        }

        public static CParser getParser(Configuration config, LogManager logger, ParserOptions options, MachineModel machine) {
            return EclipseParsers.getCParser(config, logger, options.dialect, machine);
        }
    }

    @Options(prefix="parser")
    public static final class ParserOptions {
        @Option(secure=true, description="C dialect for parser")
        private Dialect dialect = Dialect.GNUC;

        private ParserOptions() {
        }
    }

    public static enum Dialect {
        C99,
        GNUC;

    }

    public static class FileContentToParse
    extends FileToParse {
        private final String fileContent;

        public FileContentToParse(String pFileName, String pFileContent) {
            super(pFileName);
            this.fileContent = pFileContent;
        }

        public String getFileContent() {
            return this.fileContent;
        }
    }

    public static class FileToParse {
        private final String fileName;

        public FileToParse(String pFileName) {
            this.fileName = pFileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

