/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.internal.core.parser.scanner.ILexerLog;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.Token;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.exceptions.CParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;

@Options
public class CParserWithLocationMapper
implements CParser {
    private final CParser realParser;
    private final LogManager logger;
    private final boolean readLineDirectives;
    @Option(secure=true, name="locmapper.dumpTokenizedProgramToFile", description="Write the tokenized version of the input program to this file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path dumpTokenizedProgramToFile = null;
    @Option(secure=true, name="parser.transformTokensToLines", description="Preprocess the given C files before parsing: Put every single token onto a new line. Then the line number corresponds to the token number.")
    private boolean tokenizeCode = false;

    public CParserWithLocationMapper(Configuration pConfig, LogManager pLogger, CParser pRealParser, boolean pReadLineDirectives) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.realParser = pRealParser;
        this.readLineDirectives = pReadLineDirectives;
    }

    @Override
    public ParseResult parseFile(String pFilename, CSourceOriginMapping sourceOriginMapping) throws ParserException, IOException, InvalidConfigurationException, InterruptedException {
        String tokenizedCode = this.tokenizeSourcefile(pFilename, sourceOriginMapping);
        return this.realParser.parseString(pFilename, tokenizedCode, sourceOriginMapping);
    }

    private String tokenizeSourcefile(String pFilename, CSourceOriginMapping sourceOriginMapping) throws CParserException, IOException {
        String code = Paths.get((String)pFilename, (String[])new String[0]).asCharSource(Charset.defaultCharset()).read();
        return this.processCode(pFilename, code, sourceOriginMapping);
    }

    private String processCode(String fileName, String pCode, CSourceOriginMapping sourceOriginMapping) throws CParserException {
        String code;
        StringBuilder tokenizedCode = new StringBuilder();
        Lexer.LexerOptions options = new Lexer.LexerOptions();
        ILexerLog log = ILexerLog.NULL;
        Object source = null;
        Lexer lx = new Lexer(pCode.toCharArray(), options, log, source);
        try {
            Token token;
            int absoluteLineNumber;
            int relativeLineNumber = absoluteLineNumber = 1;
            String rangeLinesOriginFilename = fileName;
            int includeStartedWithAbsoluteLine = 0;
            while ((token = lx.nextToken()).getType() != 144) {
                if (token.getType() == -99) {
                    ++absoluteLineNumber;
                    ++relativeLineNumber;
                }
                if (token.getType() == 138) {
                    String firstTokenImage;
                    ArrayList directiveTokens = Lists.newArrayList();
                    token = lx.nextToken();
                    while (token.getType() != -99 && token.getType() != 144) {
                        directiveTokens.add(token);
                        token = lx.nextToken();
                    }
                    ++absoluteLineNumber;
                    ++relativeLineNumber;
                    if (directiveTokens.size() <= 0 || (firstTokenImage = ((Token)directiveTokens.get(0)).getImage()).equals("line") || !firstTokenImage.matches("[0-9]+")) continue;
                    if (this.readLineDirectives) {
                        sourceOriginMapping.mapInputLineRangeToDelta(fileName, rangeLinesOriginFilename, includeStartedWithAbsoluteLine, absoluteLineNumber, relativeLineNumber - absoluteLineNumber);
                    }
                    includeStartedWithAbsoluteLine = absoluteLineNumber;
                    relativeLineNumber = Integer.parseInt(firstTokenImage);
                    String file = ((Token)directiveTokens.get(1)).getImage();
                    if (file.charAt(0) == '\"' && file.charAt(file.length() - 1) == '\"') {
                        file = file.substring(1, file.length() - 1);
                    }
                    rangeLinesOriginFilename = file;
                    continue;
                }
                if (token.getImage().trim().isEmpty() || !this.tokenizeCode) continue;
                tokenizedCode.append(token.toString());
                tokenizedCode.append(System.lineSeparator());
            }
            if (this.readLineDirectives) {
                sourceOriginMapping.mapInputLineRangeToDelta(fileName, rangeLinesOriginFilename, includeStartedWithAbsoluteLine + 1, absoluteLineNumber, relativeLineNumber - absoluteLineNumber);
            }
        }
        catch (OffsetLimitReachedException e) {
            throw new CParserException("Tokenizing failed", e);
        }
        String string = code = this.tokenizeCode ? tokenizedCode.toString() : pCode;
        if (this.tokenizeCode && this.dumpTokenizedProgramToFile != null) {
            try (Writer out = Files.openOutputFile((Path)this.dumpTokenizedProgramToFile, (Charset)StandardCharsets.US_ASCII, (FileWriteMode[])new FileWriteMode[0]);){
                out.append(code);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write tokenized program to file");
            }
        }
        return code;
    }

    @Override
    public ParseResult parseString(String pFilename, String pCode, CSourceOriginMapping sourceOriginMapping) throws ParserException, InvalidConfigurationException {
        String tokenizedCode = this.processCode(pFilename, pCode, sourceOriginMapping);
        return this.realParser.parseString(pFilename, tokenizedCode, sourceOriginMapping);
    }

    @Override
    public Timer getParseTime() {
        return this.realParser.getParseTime();
    }

    @Override
    public Timer getCFAConstructionTime() {
        return this.realParser.getCFAConstructionTime();
    }

    @Override
    public ParseResult parseFile(List<CParser.FileToParse> pFilenames, CSourceOriginMapping sourceOriginMapping) throws CParserException, IOException, InvalidConfigurationException, InterruptedException {
        ArrayList<CParser.FileContentToParse> programFragments = new ArrayList<CParser.FileContentToParse>(pFilenames.size());
        for (CParser.FileToParse f : pFilenames) {
            String programCode = this.tokenizeSourcefile(f.getFileName(), sourceOriginMapping);
            if (programCode.isEmpty()) {
                throw new CParserException("Tokenizer returned empty program");
            }
            programFragments.add(new CParser.FileContentToParse(f.getFileName(), programCode));
        }
        return this.realParser.parseString(programFragments, sourceOriginMapping);
    }

    @Override
    public ParseResult parseString(List<CParser.FileContentToParse> pCode, CSourceOriginMapping sourceOriginMapping) throws CParserException, InvalidConfigurationException {
        ArrayList<CParser.FileContentToParse> tokenizedFragments = new ArrayList<CParser.FileContentToParse>(pCode.size());
        for (CParser.FileContentToParse f : pCode) {
            String programCode = this.processCode(f.getFileName(), f.getFileContent(), sourceOriginMapping);
            if (programCode.isEmpty()) {
                throw new CParserException("Tokenizer returned empty program");
            }
            tokenizedFragments.add(new CParser.FileContentToParse(f.getFileName(), programCode));
        }
        return this.realParser.parseString(tokenizedFragments, sourceOriginMapping);
    }

    @Override
    public CAstNode parseSingleStatement(String pCode, Scope pScope) throws CParserException, InvalidConfigurationException {
        return this.realParser.parseSingleStatement(pCode, pScope);
    }

    @Override
    public List<CAstNode> parseStatements(String pCode, Scope pScope) throws CParserException, InvalidConfigurationException {
        return this.realParser.parseStatements(pCode, pScope);
    }
}

