/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CPreprocessor;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.exceptions.CParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;

class CParserWithPreprocessor
implements CParser {
    private final CParser realParser;
    private final CPreprocessor preprocessor;

    public CParserWithPreprocessor(CParser pRealParser, CPreprocessor pPreprocessor) {
        this.realParser = pRealParser;
        this.preprocessor = pPreprocessor;
    }

    @Override
    public ParseResult parseFile(String pFilename, CSourceOriginMapping sourceOriginMapping) throws ParserException, IOException, InvalidConfigurationException, InterruptedException {
        String programCode = this.preprocessor.preprocess(pFilename);
        if (programCode.isEmpty()) {
            throw new CParserException("Preprocessor returned empty program");
        }
        return this.realParser.parseString(pFilename, programCode, sourceOriginMapping);
    }

    @Override
    public ParseResult parseString(String pFilename, String pCode, CSourceOriginMapping sourceOriginMapping) throws ParserException, InvalidConfigurationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timer getParseTime() {
        return this.realParser.getParseTime();
    }

    @Override
    public Timer getCFAConstructionTime() {
        return this.realParser.getCFAConstructionTime();
    }

    @Override
    public ParseResult parseFile(List<CParser.FileToParse> pFilenames, CSourceOriginMapping sourceOriginMapping) throws CParserException, IOException, InvalidConfigurationException, InterruptedException {
        ArrayList<CParser.FileContentToParse> programs = new ArrayList<CParser.FileContentToParse>(pFilenames.size());
        for (CParser.FileToParse p : pFilenames) {
            String programCode = this.preprocessor.preprocess(p.getFileName());
            if (programCode.isEmpty()) {
                throw new CParserException("Preprocessor returned empty program");
            }
            programs.add(new CParser.FileContentToParse(p.getFileName(), programCode));
        }
        return this.realParser.parseString(programs, sourceOriginMapping);
    }

    @Override
    public ParseResult parseString(List<CParser.FileContentToParse> pCode, CSourceOriginMapping sourceOriginMapping) throws CParserException, InvalidConfigurationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CAstNode parseSingleStatement(String pCode, Scope pScope) throws CParserException, InvalidConfigurationException {
        return this.realParser.parseSingleStatement(pCode, pScope);
    }

    @Override
    public List<CAstNode> parseStatements(String pCode, Scope pScope) throws CParserException, InvalidConfigurationException {
        return this.realParser.parseStatements(pCode, pScope);
    }
}

