/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.ProcessExecutor;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.exceptions.CParserException;

@Options(prefix="parser")
public class CPreprocessor {
    @Option(description="The command line for calling the preprocessor. May contain binary name and arguments, but won't be expanded by a shell. The source file name will be appended to this string. The preprocessor needs to print the output to stdout.")
    private String preprocessor = "cpp";
    private final LogManager logger;

    public CPreprocessor(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
    }

    public String preprocess(String file) throws CParserException, InterruptedException {
        ArrayList argList = Lists.newArrayList((Iterable)Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().split((CharSequence)this.preprocessor));
        argList.add(file);
        String[] args = argList.toArray(new String[argList.size()]);
        this.logger.log(Level.FINE, new Object[]{"Running preprocessor", argList});
        try {
            CPreprocessorExecutor executor = new CPreprocessorExecutor(this.logger, args);
            executor.sendEOF();
            int exitCode = executor.join();
            this.logger.log(Level.FINE, new Object[]{"Preprocessor finished"});
            if (exitCode != 0) {
                throw new CParserException("Preprocessor failed with exit code " + exitCode);
            }
            if (executor.errorOutputCount > 0) {
                this.logger.log(Level.WARNING, new Object[]{"Preprocessor returned successfully, but printed warnings. Please check the log above!"});
            }
            if (executor.buffer == null) {
                return "";
            }
            return executor.buffer.toString();
        }
        catch (IOException e) {
            throw new CParserException("Preprocessor failed", e);
        }
    }

    private static class CPreprocessorExecutor
    extends ProcessExecutor<IOException> {
        private static final int MAX_ERROR_OUTPUT_SHOWN = 10;
        private static final Map<String, String> ENV_VARS = ImmutableMap.of((Object)"LANG", (Object)"C");
        @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Written only by one thread")
        private volatile int errorOutputCount = 0;
        private volatile StringBuffer buffer;

        public CPreprocessorExecutor(LogManager logger, String[] args) throws IOException {
            super(logger, IOException.class, ENV_VARS, args);
        }

        protected void handleErrorOutput(String pLine) throws IOException {
            if (this.errorOutputCount == 10) {
                this.logger.log(Level.WARNING, new Object[]{"Skipping further preprocessor error output..."});
                ++this.errorOutputCount;
            } else if (this.errorOutputCount < 10) {
                ++this.errorOutputCount;
                super.handleErrorOutput(pLine);
            }
        }

        protected void handleOutput(String pLine) throws IOException {
            if (this.buffer == null) {
                this.buffer = new StringBuffer();
            }
            this.buffer.append(pLine);
            this.buffer.append('\n');
        }

        protected void handleExitCode(int pCode) throws IOException {
        }
    }
}

