/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.DefaultCTypeVisitor;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CProgramScope
implements Scope {
    private static final Function<CFANode, Iterable<? extends CSimpleDeclaration>> TO_C_SIMPLE_DECLARATIONS = new Function<CFANode, Iterable<? extends CSimpleDeclaration>>(){

        public Iterable<? extends CSimpleDeclaration> apply(CFANode pNode) {
            return CFAUtils.leavingEdges(pNode).transformAndConcat((Function)new Function<CFAEdge, Iterable<? extends CSimpleDeclaration>>(){

                public Iterable<? extends CSimpleDeclaration> apply(CFAEdge pEdge) {
                    if (pEdge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
                        CDeclaration dcl = ((CDeclarationEdge)pEdge).getDeclaration();
                        return Collections.singleton(dcl);
                    }
                    if (pEdge.getEdgeType() == CFAEdgeType.FunctionCallEdge) {
                        FunctionCallEdge fce = (FunctionCallEdge)pEdge;
                        AFunctionDeclaration decl = fce.getSuccessor().getFunctionDefinition();
                        return FluentIterable.from(decl.getParameters()).filter(CSimpleDeclaration.class);
                    }
                    if (pEdge.getEdgeType() == CFAEdgeType.MultiEdge) {
                        MultiEdge edge = (MultiEdge)pEdge;
                        ArrayList result = new ArrayList();
                        for (CFAEdge innerEdge : edge.getEdges()) {
                            Iterables.addAll(result, this.apply(innerEdge));
                        }
                        return result;
                    }
                    return Collections.emptySet();
                }
            });
        }
    };
    private static final Predicate<CSimpleDeclaration> HAS_NAME = new Predicate<CSimpleDeclaration>(){

        public boolean apply(CSimpleDeclaration pDeclaration) {
            return pDeclaration.getName() != null && pDeclaration.getQualifiedName() != null;
        }
    };
    private static final Function<CSimpleDeclaration, String> GET_NAME = new Function<CSimpleDeclaration, String>(){

        public String apply(CSimpleDeclaration pDeclaration) {
            return pDeclaration.getName();
        }
    };
    private static final Function<CSimpleDeclaration, String> GET_ORIGINAL_QUALIFIED_NAME = new Function<CSimpleDeclaration, String>(){

        public String apply(CSimpleDeclaration pDeclaration) {
            String name = pDeclaration.getName();
            String originalName = pDeclaration.getOrigName();
            String qualifiedName = pDeclaration.getQualifiedName();
            if (name.equals(originalName)) {
                return qualifiedName;
            }
            assert (qualifiedName.endsWith(name));
            return qualifiedName.substring(0, qualifiedName.length() - name.length()) + originalName;
        }
    };
    private final String currentFile = "";
    private final Set<String> variableNames;
    private final Map<String, CSimpleDeclaration> uniqueSimpleDeclarations;
    private final Multimap<String, CFunctionDeclaration> functionDeclarations;
    private final Map<String, CSimpleDeclaration> qualifiedDeclarations;
    private final Map<String, CType> qualifiedTypeDefs;
    private final Map<String, CComplexType> qualifiedTypes;
    private final String functionName;

    private CProgramScope() {
        this.variableNames = Collections.emptySet();
        this.qualifiedDeclarations = Collections.emptyMap();
        this.uniqueSimpleDeclarations = Collections.emptyMap();
        this.functionDeclarations = ImmutableListMultimap.of();
        this.qualifiedTypes = Collections.emptyMap();
        this.qualifiedTypeDefs = Collections.emptyMap();
        this.functionName = null;
    }

    private CProgramScope(CProgramScope pScope, String pFunctionName) {
        this.variableNames = pScope.variableNames;
        this.uniqueSimpleDeclarations = pScope.uniqueSimpleDeclarations;
        this.functionDeclarations = pScope.functionDeclarations;
        this.qualifiedDeclarations = pScope.qualifiedDeclarations;
        this.qualifiedTypes = pScope.qualifiedTypes;
        this.qualifiedTypeDefs = pScope.qualifiedTypeDefs;
        this.functionName = pFunctionName;
    }

    public CProgramScope(CFA cfa, LogManager pLogger) {
        assert (cfa.getLanguage() == Language.C);
        this.functionName = null;
        Collection<CFANode> nodes = cfa.getAllNodes();
        FluentIterable dcls = FluentIterable.from(nodes).transformAndConcat(TO_C_SIMPLE_DECLARATIONS).filter(HAS_NAME);
        FluentIterable functionDcls = dcls.filter(CFunctionDeclaration.class);
        FluentIterable nonFunctionDcls = dcls.filter(Predicates.not((Predicate)Predicates.instanceOf(CFunctionDeclaration.class)));
        FluentIterable typeDcls = dcls.filter(CTypeDeclaration.class);
        this.qualifiedTypes = CProgramScope.extractTypes((FluentIterable<? extends CSimpleDeclaration>)nonFunctionDcls, pLogger);
        this.qualifiedTypeDefs = CProgramScope.extractTypeDefs((FluentIterable<CTypeDeclaration>)typeDcls, pLogger);
        this.functionDeclarations = functionDcls.index(GET_ORIGINAL_QUALIFIED_NAME);
        this.variableNames = nonFunctionDcls.transform(GET_NAME).toSet();
        this.qualifiedDeclarations = CProgramScope.extractQualifiedDeclarations((FluentIterable<CSimpleDeclaration>)nonFunctionDcls, pLogger);
        this.uniqueSimpleDeclarations = CProgramScope.extractUniqueSimpleDeclarations(this.qualifiedDeclarations);
    }

    public static CProgramScope empty() {
        return new CProgramScope();
    }

    @Override
    public boolean isGlobalScope() {
        return false;
    }

    @Override
    public boolean variableNameInUse(String pName) {
        return this.variableNames.contains(pName);
    }

    @Override
    public CSimpleDeclaration lookupVariable(String pName) {
        CSimpleDeclaration result;
        if (this.simulatesFunctionScope() && (result = this.qualifiedDeclarations.get(this.getCurrentFunctionName() + "::" + pName)) != null) {
            return result;
        }
        result = this.qualifiedDeclarations.get(pName);
        if (result != null) {
            return result;
        }
        return this.uniqueSimpleDeclarations.get(pName);
    }

    @Override
    public CFunctionDeclaration lookupFunction(String pName) {
        Iterator i$ = this.functionDeclarations.get((Object)pName).iterator();
        if (i$.hasNext()) {
            CFunctionDeclaration result = (CFunctionDeclaration)i$.next();
            return result;
        }
        return null;
    }

    @Override
    public CComplexType lookupType(String pName) {
        CComplexType result = null;
        if (this.simulatesFunctionScope()) {
            String functionQualifiedName = this.getCurrentFunctionName() + "::" + pName;
            result = CProgramScope.lookupQualifiedComplexType(functionQualifiedName, this.qualifiedTypes);
            if (result != null) {
                return result;
            }
            result = this.qualifiedTypes.get(functionQualifiedName);
            if (result != null) {
                return result;
            }
        }
        if ((result = CProgramScope.lookupQualifiedComplexType(pName, this.qualifiedTypes)) != null) {
            return result;
        }
        result = this.qualifiedTypes.get(pName);
        if (result != null) {
            return result;
        }
        CType typdefResult = this.lookupTypedef(pName);
        if (typdefResult instanceof CComplexType) {
            return (CComplexType)typdefResult;
        }
        return null;
    }

    @Override
    public CType lookupTypedef(String pName) {
        CType result = null;
        if (this.simulatesFunctionScope()) {
            String functionQualifiedName = this.getCurrentFunctionName() + "::" + pName;
            result = CProgramScope.lookupQualifiedComplexType(functionQualifiedName, this.qualifiedTypeDefs);
            if (result != null) {
                return result;
            }
            result = this.qualifiedTypeDefs.get(functionQualifiedName);
            if (result != null) {
                return result;
            }
        }
        if ((result = CProgramScope.lookupQualifiedComplexType(pName, this.qualifiedTypeDefs)) != null) {
            return result;
        }
        return this.qualifiedTypeDefs.get(pName);
    }

    @Override
    public void registerDeclaration(CSimpleDeclaration pDeclaration) {
    }

    @Override
    public boolean registerTypeDeclaration(CComplexTypeDeclaration pDeclaration) {
        return false;
    }

    @Override
    public String createScopedNameOf(String pName) {
        if (this.simulatesFunctionScope()) {
            return this.getCurrentFunctionName() + "::" + pName;
        }
        return pName;
    }

    @Override
    public String getRenamedTypeName(String type) {
        return type + "__" + "";
    }

    public CProgramScope createFunctionScope(String pFunctionName) {
        return new CProgramScope(this, pFunctionName);
    }

    public boolean simulatesFunctionScope() {
        return this.functionName != null;
    }

    public String getCurrentFunctionName() {
        Preconditions.checkState((boolean)this.simulatesFunctionScope());
        return this.functionName;
    }

    private static boolean equals(CType pA, CType pB) {
        return CProgramScope.equals(pA, pB, Sets.newHashSet());
    }

    private static boolean equals(@Nullable CType pA, @Nullable CType pB, Set<Pair<CType, CType>> pResolved) {
        if (pA == pB) {
            return true;
        }
        if (pA == null) {
            return false;
        }
        Pair ab = Pair.of((Object)pA, (Object)pB);
        if (pResolved.contains(ab)) {
            return true;
        }
        boolean nonRecEq = pA.equals(pB);
        if (!nonRecEq) {
            return false;
        }
        if (!(pA instanceof CCompositeType)) {
            pResolved.add((Pair<CType, CType>)ab);
            return true;
        }
        CCompositeType aComp = (CCompositeType)pA;
        CCompositeType bComp = (CCompositeType)pB;
        if (aComp.getMembers().size() != bComp.getMembers().size()) {
            return false;
        }
        pResolved.add((Pair<CType, CType>)ab);
        Iterator<CCompositeType.CCompositeTypeMemberDeclaration> aMembers = aComp.getMembers().iterator();
        for (CCompositeType.CCompositeTypeMemberDeclaration bMember : bComp.getMembers()) {
            if (CProgramScope.equals(aMembers.next().getType(), bMember.getType(), pResolved)) continue;
            pResolved.remove(ab);
            return false;
        }
        return true;
    }

    private static Map<String, CSimpleDeclaration> extractQualifiedDeclarations(FluentIterable<CSimpleDeclaration> pNonFunctionDcls, LogManager pLogger) {
        ImmutableListMultimap qualifiedDeclarationsMultiMap = pNonFunctionDcls.index(GET_ORIGINAL_QUALIFIED_NAME);
        HashMap qualifiedDeclarations = Maps.newHashMap();
        for (Map.Entry declarationsEntry : qualifiedDeclarationsMultiMap.asMap().entrySet()) {
            String qualifiedName = (String)declarationsEntry.getKey();
            Collection declarations = (Collection)declarationsEntry.getValue();
            ImmutableSet duplicateFreeDeclarations = FluentIterable.from((Iterable)declarations).transform((Function)new Function<CSimpleDeclaration, CSimpleDeclaration>(){

                public CSimpleDeclaration apply(CSimpleDeclaration pArg0) {
                    if (pArg0 instanceof CVariableDeclaration) {
                        CVariableDeclaration original = (CVariableDeclaration)pArg0;
                        if (original.getInitializer() == null) {
                            return pArg0;
                        }
                        return new CVariableDeclaration(original.getFileLocation(), original.isGlobal(), original.getCStorageClass(), original.getType(), original.getName(), original.getOrigName(), original.getQualifiedName(), null);
                    }
                    return pArg0;
                }
            }).toSet();
            if (duplicateFreeDeclarations.isEmpty()) continue;
            if (duplicateFreeDeclarations.size() == 1) {
                qualifiedDeclarations.put(qualifiedName, declarations.iterator().next());
                continue;
            }
            pLogger.log(Level.FINEST, new Object[]{"Ignoring declaration for", qualifiedName, " for creation of program-wide scope because it is not unique."});
        }
        return Collections.unmodifiableMap(qualifiedDeclarations);
    }

    private static Map<String, CComplexType> extractTypes(FluentIterable<? extends CSimpleDeclaration> pDcls, LogManager pLogger) {
        TypeCollector typeCollector = new TypeCollector();
        for (CSimpleDeclaration declaration : pDcls) {
            declaration.getType().accept(typeCollector);
        }
        ImmutableListMultimap typesMap = FluentIterable.from(typeCollector.getCollectedTypes()).filter(CComplexType.class).index((Function)new Function<CComplexType, String>(){

            public String apply(CComplexType pArg0) {
                return pArg0.getQualifiedName();
            }
        });
        HashMap uniqueTypes = Maps.newHashMap();
        for (Map.Entry typeEntry : typesMap.asMap().entrySet()) {
            String qualifiedName = (String)typeEntry.getKey();
            Collection types = (Collection)typeEntry.getValue();
            CProgramScope.putIfUnique(uniqueTypes, qualifiedName, types, pLogger);
        }
        return Collections.unmodifiableMap(uniqueTypes);
    }

    private static Map<String, CType> extractTypeDefs(FluentIterable<CTypeDeclaration> pTypeDcls, LogManager pLogger) {
        FluentIterable plainTypeDefs = pTypeDcls.filter(CTypeDefDeclaration.class);
        ImmutableListMultimap typeDefDeclarationsMap = plainTypeDefs.index((Function)new Function<CTypeDefDeclaration, String>(){

            public String apply(CTypeDefDeclaration pArg0) {
                return pArg0.getQualifiedName();
            }
        });
        HashMap uniqueTypeDefs = Maps.newHashMap();
        for (Map.Entry typeDefEntry : typeDefDeclarationsMap.asMap().entrySet()) {
            String qualifiedName = (String)typeDefEntry.getKey();
            FluentIterable types = FluentIterable.from((Iterable)((Iterable)typeDefEntry.getValue())).transform((Function)new Function<CTypeDefDeclaration, CType>(){

                public CType apply(CTypeDefDeclaration pArg0) {
                    return pArg0.getType();
                }
            });
            CProgramScope.putIfUnique(uniqueTypeDefs, qualifiedName, types, pLogger);
        }
        return Collections.unmodifiableMap(uniqueTypeDefs);
    }

    private static Map<String, CSimpleDeclaration> extractUniqueSimpleDeclarations(Map<String, CSimpleDeclaration> pQualifiedDeclarations) {
        return Maps.transformEntries((Map)Maps.filterEntries((Map)FluentIterable.from(pQualifiedDeclarations.values()).index(GET_NAME).asMap(), (Predicate)new Predicate<Map.Entry<String, Collection<CSimpleDeclaration>>>(){

            public boolean apply(Map.Entry<String, Collection<CSimpleDeclaration>> pArg0) {
                return pArg0.getValue().size() == 1;
            }
        }), (Maps.EntryTransformer)new Maps.EntryTransformer<String, Collection<CSimpleDeclaration>, CSimpleDeclaration>(){

            public CSimpleDeclaration transformEntry(String pArg0, @Nonnull Collection<CSimpleDeclaration> pArg1) {
                return pArg1.iterator().next();
            }
        });
    }

    private static <T extends CType> void putIfUnique(Map<String, ? super T> pTarget, String pQualifiedName, Iterable<? extends T> pValues, LogManager pLogger) {
        if (!Iterables.isEmpty(pValues)) {
            Iterator<T> typeIterator = pValues.iterator();
            CType firstType = (CType)typeIterator.next();
            CType firstChecktype = CProgramScope.resolveElaboratedTypeForEqualityCheck(firstType);
            boolean duplicateFound = false;
            while (typeIterator.hasNext() && !duplicateFound) {
                if (CProgramScope.equals(firstChecktype, CProgramScope.resolveElaboratedTypeForEqualityCheck((CType)typeIterator.next()))) continue;
                pLogger.log(Level.FINEST, new Object[]{"Ignoring declaration for", pQualifiedName, " for creation of program-wide scope because it is not unique."});
                duplicateFound = true;
            }
            if (!duplicateFound) {
                for (CType type : pValues) {
                    if (!(type instanceof CElaboratedType)) continue;
                    pTarget.put(pQualifiedName, type);
                    return;
                }
                pTarget.put(pQualifiedName, firstType);
            }
        }
    }

    private static CType resolveElaboratedTypeForEqualityCheck(CType pType) {
        CType currentType = pType;
        while (currentType instanceof CElaboratedType) {
            currentType = ((CElaboratedType)currentType).getRealType();
        }
        return currentType;
    }

    private static <T> T lookupQualifiedComplexType(String pName, Map<String, T> pStorage) {
        HashSet potentialResults = Sets.newHashSet();
        for (CComplexType.ComplexTypeKind kind : CComplexType.ComplexTypeKind.values()) {
            T potentialResult = pStorage.get(kind.toASTString() + " " + pName);
            if (potentialResult == null) continue;
            potentialResults.add(potentialResult);
        }
        if (potentialResults.size() == 1) {
            return (T)potentialResults.iterator().next();
        }
        return null;
    }

    private static class TypeCollector
    extends DefaultCTypeVisitor<Void, RuntimeException> {
        private final Set<CType> collectedTypes;

        public TypeCollector() {
            this(Sets.newHashSet());
        }

        public TypeCollector(Set<CType> pCollectedTypes) {
            this.collectedTypes = pCollectedTypes;
        }

        public Set<CType> getCollectedTypes() {
            return Collections.unmodifiableSet(this.collectedTypes);
        }

        @Override
        public Void visitDefault(CType pT) {
            this.collectedTypes.add(pT);
            return null;
        }

        @Override
        public Void visit(CArrayType pArrayType) {
            if (!this.collectedTypes.contains(pArrayType)) {
                this.collectedTypes.add(pArrayType);
                pArrayType.getType().accept(this);
                if (pArrayType.getLength() != null) {
                    pArrayType.getLength().getExpressionType().accept(this);
                }
            }
            return null;
        }

        @Override
        public Void visit(CCompositeType pCompositeType) {
            if (!this.collectedTypes.contains(pCompositeType)) {
                this.collectedTypes.add(pCompositeType);
                for (CCompositeType.CCompositeTypeMemberDeclaration member : pCompositeType.getMembers()) {
                    member.getType().accept(this);
                }
            }
            return null;
        }

        @Override
        public Void visit(CElaboratedType pElaboratedType) {
            if (!this.collectedTypes.contains(pElaboratedType)) {
                this.collectedTypes.add(pElaboratedType);
                if (pElaboratedType.getRealType() != null) {
                    pElaboratedType.getRealType().accept(this);
                }
            }
            return null;
        }

        @Override
        public Void visit(CFunctionType pFunctionType) {
            if (!this.collectedTypes.contains(pFunctionType)) {
                this.collectedTypes.add(pFunctionType);
                for (CType parameterType : pFunctionType.getParameters()) {
                    parameterType.accept(this);
                }
            }
            return null;
        }

        @Override
        public Void visit(CPointerType pPointerType) {
            if (!this.collectedTypes.contains(pPointerType)) {
                this.collectedTypes.add(pPointerType);
                pPointerType.getType().accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CTypedefType pTypedefType) {
            if (!this.collectedTypes.contains(pTypedefType)) {
                this.collectedTypes.add(pTypedefType);
                pTypedefType.getRealType().accept(this);
            }
            return null;
        }
    }
}

