/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.Pair;

public class CSourceOriginMapping {
    private final Map<String, RangeMap<Integer, Pair<String, Integer>>> mapping = new HashMap<String, RangeMap<Integer, Pair<String, Integer>>>();

    void mapInputLineRangeToDelta(String inputFilename, String originFilename, int fromInputLineNumber, int toInputLineNumber, int deltaLinesToOrigin) {
        TreeRangeMap fileMapping = this.mapping.get(inputFilename);
        if (fileMapping == null) {
            fileMapping = TreeRangeMap.create();
            this.mapping.put(inputFilename, (RangeMap<Integer, Pair<String, Integer>>)fileMapping);
        }
        Range lineRange = Range.openClosed((Comparable)Integer.valueOf(fromInputLineNumber - 1), (Comparable)Integer.valueOf(toInputLineNumber));
        fileMapping.put(lineRange, (Object)Pair.of((Object)originFilename, (Object)deltaLinesToOrigin));
    }

    public Pair<String, Integer> getOriginLineFromAnalysisCodeLine(String analysisFile, int analysisCodeLine) {
        Pair originFileAndLineDelta;
        RangeMap<Integer, Pair<String, Integer>> fileMapping = this.mapping.get(analysisFile);
        if (fileMapping != null && (originFileAndLineDelta = (Pair)fileMapping.get((Comparable)Integer.valueOf(analysisCodeLine))) != null) {
            return Pair.of((Object)originFileAndLineDelta.getFirst(), (Object)(analysisCodeLine + (Integer)originFileAndLineDelta.getSecond()));
        }
        return Pair.of((Object)analysisFile, (Object)analysisCodeLine);
    }
}

