/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;

public class FunctionCallCollector
extends CFATraversal.DefaultCFAVisitor {
    private final List<AStatementEdge> functionCalls = new ArrayList<AStatementEdge>();

    public Collection<AStatementEdge> getFunctionCalls() {
        return Collections.unmodifiableCollection(this.functionCalls);
    }

    @Override
    public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
        switch (pEdge.getEdgeType()) {
            case StatementEdge: {
                AStatementEdge edge = (AStatementEdge)pEdge;
                if (!(edge.getStatement() instanceof AFunctionCall)) break;
                this.functionCalls.add(edge);
                break;
            }
            case FunctionCallEdge: 
            case FunctionReturnEdge: 
            case CallToReturnEdge: {
                throw new AssertionError((Object)"functioncall- and return-edges should not exist at this time.");
            }
        }
        return CFATraversal.TraversalProcess.CONTINUE;
    }
}

