/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.VariableClassification;

class ImmutableCFA
implements CFA {
    private final MachineModel machineModel;
    private final ImmutableSortedMap<String, FunctionEntryNode> functions;
    private final ImmutableSortedSet<CFANode> allNodes;
    private final FunctionEntryNode mainFunction;
    private final Optional<LoopStructure> loopStructure;
    private final Optional<VariableClassification> varClassification;
    private final Optional<LiveVariables> liveVariables;
    private final Language language;

    ImmutableCFA(MachineModel pMachineModel, Map<String, FunctionEntryNode> pFunctions, SetMultimap<String, CFANode> pAllNodes, FunctionEntryNode pMainFunction, Optional<LoopStructure> pLoopStructure, Optional<VariableClassification> pVarClassification, Optional<LiveVariables> pLiveVariables, Language pLanguage) {
        this.machineModel = pMachineModel;
        this.functions = ImmutableSortedMap.copyOf(pFunctions);
        this.allNodes = ImmutableSortedSet.copyOf((Collection)pAllNodes.values());
        this.mainFunction = (FunctionEntryNode)Preconditions.checkNotNull((Object)pMainFunction);
        this.loopStructure = pLoopStructure;
        this.varClassification = pVarClassification;
        this.liveVariables = pLiveVariables;
        this.language = pLanguage;
        Preconditions.checkArgument((this.functions.get((Object)this.mainFunction.getFunctionName()) == this.mainFunction ? 1 : 0) != 0);
    }

    private ImmutableCFA(MachineModel pMachineModel, Language pLanguage) {
        this.machineModel = pMachineModel;
        this.functions = ImmutableSortedMap.of();
        this.allNodes = ImmutableSortedSet.of();
        this.mainFunction = null;
        this.loopStructure = Optional.absent();
        this.varClassification = Optional.absent();
        this.liveVariables = Optional.absent();
        this.language = pLanguage;
    }

    static ImmutableCFA empty(MachineModel pMachineModel, Language pLanguage) {
        return new ImmutableCFA(pMachineModel, pLanguage);
    }

    @Override
    public MachineModel getMachineModel() {
        return this.machineModel;
    }

    @Override
    public boolean isEmpty() {
        return this.functions.isEmpty();
    }

    @Override
    public int getNumberOfFunctions() {
        return this.functions.size();
    }

    public ImmutableSortedSet<String> getAllFunctionNames() {
        return this.functions.keySet();
    }

    public ImmutableCollection<FunctionEntryNode> getAllFunctionHeads() {
        return this.functions.values();
    }

    @Override
    public FunctionEntryNode getFunctionHead(String name) {
        return (FunctionEntryNode)this.functions.get((Object)name);
    }

    public ImmutableSortedMap<String, FunctionEntryNode> getAllFunctions() {
        return this.functions;
    }

    public ImmutableSortedSet<CFANode> getAllNodes() {
        return this.allNodes;
    }

    @Override
    public FunctionEntryNode getMainFunction() {
        return this.mainFunction;
    }

    @Override
    public Optional<LoopStructure> getLoopStructure() {
        return this.loopStructure;
    }

    @Override
    public Optional<ImmutableSet<CFANode>> getAllLoopHeads() {
        if (this.loopStructure.isPresent()) {
            return Optional.of(((LoopStructure)this.loopStructure.get()).getAllLoopHeads());
        }
        return Optional.absent();
    }

    @Override
    public Optional<VariableClassification> getVarClassification() {
        return this.varClassification;
    }

    @Override
    public Optional<LiveVariables> getLiveVariables() {
        return this.liveVariables;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }
}

