/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ImmutableCFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.VariableClassification;

public class MutableCFA
implements CFA {
    private final MachineModel machineModel;
    private final SortedMap<String, FunctionEntryNode> functions;
    private final SortedSetMultimap<String, CFANode> allNodes;
    private final FunctionEntryNode mainFunction;
    private final Language language;
    private Optional<LoopStructure> loopStructure = Optional.absent();
    private Optional<LiveVariables> liveVariables = Optional.absent();

    public MutableCFA(MachineModel pMachineModel, SortedMap<String, FunctionEntryNode> pFunctions, SortedSetMultimap<String, CFANode> pAllNodes, FunctionEntryNode pMainFunction, Language pLanguage) {
        this.machineModel = pMachineModel;
        this.functions = pFunctions;
        this.allNodes = pAllNodes;
        this.mainFunction = pMainFunction;
        this.language = pLanguage;
        assert (this.functions.keySet().equals(this.allNodes.keySet()));
        assert (this.functions.get(this.mainFunction.getFunctionName()) == this.mainFunction);
    }

    public void addNode(CFANode pNode) {
        assert (this.functions.containsKey(pNode.getFunctionName()));
        this.allNodes.put((Object)pNode.getFunctionName(), (Object)pNode);
    }

    public void clear() {
        this.functions.clear();
        this.allNodes.clear();
    }

    public void removeNode(CFANode pNode) {
        SortedSet functionNodes = this.allNodes.get((Object)pNode.getFunctionName());
        assert (functionNodes.contains(pNode));
        functionNodes.remove(pNode);
        if (functionNodes.isEmpty()) {
            this.functions.remove(pNode.getFunctionName());
        }
    }

    @Override
    public MachineModel getMachineModel() {
        return this.machineModel;
    }

    @Override
    public boolean isEmpty() {
        return this.functions.isEmpty();
    }

    @Override
    public int getNumberOfFunctions() {
        return this.functions.size();
    }

    @Override
    public Set<String> getAllFunctionNames() {
        return Collections.unmodifiableSet(this.functions.keySet());
    }

    @Override
    public Collection<FunctionEntryNode> getAllFunctionHeads() {
        return Collections.unmodifiableCollection(this.functions.values());
    }

    @Override
    public FunctionEntryNode getFunctionHead(String pName) {
        return (FunctionEntryNode)this.functions.get(pName);
    }

    @Override
    public Map<String, FunctionEntryNode> getAllFunctions() {
        return Collections.unmodifiableMap(this.functions);
    }

    public SortedSet<CFANode> getFunctionNodes(String pName) {
        return Collections.unmodifiableSortedSet(this.allNodes.get((Object)pName));
    }

    @Override
    public Collection<CFANode> getAllNodes() {
        return Collections.unmodifiableCollection(this.allNodes.values());
    }

    @Override
    public FunctionEntryNode getMainFunction() {
        return this.mainFunction;
    }

    @Override
    public Optional<LoopStructure> getLoopStructure() {
        return this.loopStructure;
    }

    public void setLoopStructure(Optional<LoopStructure> pLoopStructure) {
        this.loopStructure = (Optional)Preconditions.checkNotNull(pLoopStructure);
    }

    @Override
    public Optional<ImmutableSet<CFANode>> getAllLoopHeads() {
        if (this.loopStructure.isPresent()) {
            return Optional.of(((LoopStructure)this.loopStructure.get()).getAllLoopHeads());
        }
        return Optional.absent();
    }

    public ImmutableCFA makeImmutableCFA(Optional<VariableClassification> pVarClassification) {
        return new ImmutableCFA(this.machineModel, (Map<String, FunctionEntryNode>)this.functions, (SetMultimap<String, CFANode>)this.allNodes, this.mainFunction, this.loopStructure, pVarClassification, this.liveVariables, this.language);
    }

    @Override
    public Optional<VariableClassification> getVarClassification() {
        return Optional.absent();
    }

    @Override
    public Optional<LiveVariables> getLiveVariables() {
        return this.liveVariables;
    }

    public void setLiveVariables(Optional<LiveVariables> pLiveVariables) {
        this.liveVariables = pLiveVariables;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }
}

