/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import org.sosy_lab.cpachecker.cfa.ast.ALiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.types.Type;

public abstract class ACharLiteralExpression
extends ALiteralExpression {
    private final char character;

    public ACharLiteralExpression(FileLocation pFileLocation, Type pType, char pCharacter) {
        super(pFileLocation, pType);
        this.character = pCharacter;
    }

    public char getCharacter() {
        return this.character;
    }

    @Override
    public Character getValue() {
        return Character.valueOf(this.getCharacter());
    }

    @Override
    public String toASTString() {
        if (this.character >= ' ' && this.character < '\u0080') {
            return "'" + this.character + "'";
        }
        return "'\\x" + Integer.toHexString(this.character) + "'";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + this.character;
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ACharLiteralExpression) || !super.equals(obj)) {
            return false;
        }
        ACharLiteralExpression other = (ACharLiteralExpression)obj;
        return other.character == this.character;
    }
}

