/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AbstractRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.types.Type;

public abstract class AFunctionCallExpression
extends AbstractRightHandSide {
    private final AExpression functionName;
    private final List<? extends AExpression> parameters;
    private final AFunctionDeclaration declaration;

    public AFunctionCallExpression(FileLocation pFileLocation, Type pType, AExpression pFunctionName, List<? extends AExpression> pParameters, AFunctionDeclaration pDeclaration) {
        super(pFileLocation, pType);
        this.functionName = pFunctionName;
        this.parameters = ImmutableList.copyOf(pParameters);
        this.declaration = pDeclaration;
    }

    public AExpression getFunctionNameExpression() {
        return this.functionName;
    }

    public List<? extends AExpression> getParameterExpressions() {
        return this.parameters;
    }

    public AFunctionDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public String toASTString() {
        StringBuilder lASTString = new StringBuilder();
        lASTString.append(this.functionName.toParenthesizedASTString());
        lASTString.append("(");
        Joiner.on((String)", ").appendTo(lASTString, Iterables.transform(this.parameters, (Function)AExpression.TO_AST_STRING));
        lASTString.append(")");
        return lASTString.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.declaration);
        result = 31 * result + Objects.hashCode(this.functionName);
        result = 31 * result + Objects.hashCode(this.parameters);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AFunctionCallExpression) || !super.equals(obj)) {
            return false;
        }
        AFunctionCallExpression other = (AFunctionCallExpression)obj;
        return Objects.equals(other.declaration, this.declaration) && Objects.equals(other.functionName, this.functionName) && Objects.equals(other.parameters, this.parameters);
    }
}

