/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.types.Type;

public abstract class AUnaryExpression
extends AbstractExpression {
    private final AExpression operand;
    private final AUnaryOperator operator;

    public AUnaryExpression(FileLocation pFileLocation, Type pType, AExpression pOperand, AUnaryOperator pOperator) {
        super(pFileLocation, pType);
        this.operand = pOperand;
        this.operator = pOperator;
    }

    public AExpression getOperand() {
        return this.operand;
    }

    public AUnaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public String toASTString() {
        return this.operator.getOperator() + this.operand.toParenthesizedASTString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hash(this.operand);
        result = 31 * result + Objects.hash(this.operator);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AUnaryExpression) || !super.equals(obj)) {
            return false;
        }
        AUnaryExpression other = (AUnaryExpression)obj;
        return Objects.equals(other.operand, this.operand) && Objects.equals(other.operator, this.operator);
    }

    public static interface AUnaryOperator {
        public String getOperator();
    }
}

