/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.AbstractDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.types.Type;

public abstract class AVariableDeclaration
extends AbstractDeclaration {
    private final String qualifiedName;
    private AInitializer initializer;

    public AVariableDeclaration(FileLocation pFileLocation, boolean pIsGlobal, Type pType, String pName, String pOrigName, String pQualifiedName, AInitializer pInitializer) {
        super(pFileLocation, pIsGlobal, pType, pName, pOrigName);
        this.qualifiedName = (String)Preconditions.checkNotNull((Object)pQualifiedName);
        this.initializer = pInitializer;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public AInitializer getInitializer() {
        return this.initializer;
    }

    @Override
    public String toASTString() {
        StringBuilder lASTString = new StringBuilder();
        lASTString.append(this.getType().toASTString(this.getName()));
        if (this.initializer != null) {
            lASTString.append(" = ");
            lASTString.append(this.initializer.toASTString());
        }
        lASTString.append(";");
        return lASTString.toString();
    }

    protected void addInitializer(AInitializer pCInitializer) {
        Preconditions.checkState((this.getInitializer() == null ? 1 : 0) != 0);
        this.initializer = pCInitializer;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.initializer);
        result = 31 * result + this.qualifiedName.hashCode();
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AVariableDeclaration) || !super.equals(obj)) {
            return false;
        }
        AVariableDeclaration other = (AVariableDeclaration)obj;
        return Objects.equals(other.initializer, this.initializer) && this.qualifiedName.equals(other.qualifiedName);
    }
}

