/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.AbstractAstNode;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;

public abstract class AbstractReturnStatement
extends AbstractAstNode
implements AReturnStatement {
    private final Optional<? extends AExpression> expression;
    private final Optional<? extends AAssignment> assignment;

    public AbstractReturnStatement(FileLocation pFileLocation, Optional<? extends AExpression> pExpression, Optional<? extends AAssignment> pAssignment) {
        super(pFileLocation);
        this.expression = (Optional)Preconditions.checkNotNull(pExpression);
        this.assignment = (Optional)Preconditions.checkNotNull(pAssignment);
    }

    @Override
    public String toASTString() {
        return "return" + (this.expression.isPresent() ? " " + ((AExpression)this.expression.get()).toASTString() : "") + ";";
    }

    @Override
    public Optional<? extends AExpression> getReturnValue() {
        return this.expression;
    }

    @Override
    public Optional<? extends AAssignment> asAssignment() {
        return this.assignment;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.expression);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractReturnStatement) || !super.equals(obj)) {
            return false;
        }
        AbstractReturnStatement other = (AbstractReturnStatement)obj;
        return Objects.equals(other.expression, this.expression);
    }
}

