/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;

public class FileLocation {
    private final int endingLine;
    private final String fileName;
    private final String niceFileName;
    private final int length;
    private final int offset;
    private final int startingLine;
    private final int startingLineInOrigin;
    public static final FileLocation DUMMY = new FileLocation(0, "<none>", 0, 0, 0){

        @Override
        public String toString() {
            return "none";
        }
    };
    public static final FileLocation MULTIPLE_FILES = new FileLocation(0, "<multiple files>", 0, 0, 0){

        @Override
        public String toString() {
            return this.getFileName();
        }
    };

    public FileLocation(int pEndingLine, String pFileName, int pLength, int pOffset, int pStartingLine) {
        this(pEndingLine, pFileName, pFileName, pLength, pOffset, pStartingLine, pStartingLine);
    }

    public FileLocation(int pEndingLine, String pFileName, String pNiceFileName, int pLength, int pOffset, int pStartingLine, int pStartingLineInOrigin) {
        this.endingLine = pEndingLine;
        this.fileName = (String)Preconditions.checkNotNull((Object)pFileName);
        this.niceFileName = (String)Preconditions.checkNotNull((Object)pNiceFileName);
        this.length = pLength;
        this.offset = pOffset;
        this.startingLine = pStartingLine;
        this.startingLineInOrigin = pStartingLineInOrigin;
    }

    public static FileLocation merge(List<FileLocation> locations) {
        Preconditions.checkArgument((!Iterables.isEmpty(locations) ? 1 : 0) != 0);
        String fileName = null;
        String niceFileName = null;
        int startingLine = Integer.MAX_VALUE;
        int startingLineInOrigin = Integer.MAX_VALUE;
        int endingLine = Integer.MIN_VALUE;
        for (FileLocation loc : locations) {
            if (loc == DUMMY) continue;
            if (fileName == null) {
                fileName = loc.fileName;
                niceFileName = loc.niceFileName;
            } else if (!fileName.equals(loc.fileName)) {
                return MULTIPLE_FILES;
            }
            startingLine = Math.min(startingLine, loc.getStartingLineNumber());
            startingLineInOrigin = Math.min(startingLineInOrigin, loc.getStartingLineInOrigin());
            endingLine = Math.max(endingLine, loc.getEndingLineNumber());
        }
        if (fileName == null) {
            return DUMMY;
        }
        return new FileLocation(endingLine, fileName, niceFileName, 0, 0, startingLine, startingLineInOrigin);
    }

    public int getStartingLineInOrigin() {
        return this.startingLineInOrigin;
    }

    public int getEndingLineNumber() {
        return this.endingLine;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getNodeLength() {
        return this.length;
    }

    public int getNodeOffset() {
        return this.offset;
    }

    public int getStartingLineNumber() {
        return this.startingLine;
    }

    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + this.endingLine;
        result = 31 * result + Objects.hashCode(this.fileName);
        result = 31 * result + this.length;
        result = 31 * result + this.offset;
        result = 31 * result + this.startingLine;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileLocation)) {
            return false;
        }
        FileLocation other = (FileLocation)obj;
        return other.endingLine == this.endingLine && other.startingLine == this.startingLine && other.length == this.length && other.offset == this.offset && Objects.equals(other.fileName, this.fileName);
    }

    public String toString() {
        String prefix;
        String string = prefix = this.niceFileName.isEmpty() ? "" : this.niceFileName + ", ";
        if (this.startingLine == this.endingLine) {
            return prefix + "line " + this.startingLineInOrigin;
        }
        return prefix + "lines " + this.startingLineInOrigin + "-" + (this.endingLine - this.startingLine + this.startingLineInOrigin);
    }
}

