/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.ABinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public class CBinaryExpression
extends ABinaryExpression
implements CExpression {
    private final CType calculationType;

    public CBinaryExpression(FileLocation pFileLocation, CType pExpressionType, CType pCalculationType, CExpression pOperand1, CExpression pOperand2, BinaryOperator pOperator) {
        super(pFileLocation, pExpressionType, pOperand1, pOperand2, pOperator);
        this.calculationType = pCalculationType;
    }

    @Override
    public <R, X extends Exception> R accept(CExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public CType getExpressionType() {
        return (CType)super.getExpressionType();
    }

    public CType getCalculationType() {
        return this.calculationType;
    }

    @Override
    public CExpression getOperand1() {
        return (CExpression)super.getOperand1();
    }

    @Override
    public CExpression getOperand2() {
        return (CExpression)super.getOperand2();
    }

    @Override
    public BinaryOperator getOperator() {
        return (BinaryOperator)super.getOperator();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.calculationType);
        return result * 31 + super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CBinaryExpression)) {
            return false;
        }
        CBinaryExpression other = (CBinaryExpression)obj;
        return Objects.equals(other.calculationType, this.calculationType) && super.equals(obj);
    }

    public static enum BinaryOperator implements ABinaryExpression.ABinaryOperator
    {
        MULTIPLY("*"),
        DIVIDE("/"),
        MODULO("%"),
        PLUS("+"),
        MINUS("-"),
        SHIFT_LEFT("<<"),
        SHIFT_RIGHT(">>"),
        LESS_THAN("<"),
        GREATER_THAN(">"),
        LESS_EQUAL("<="),
        GREATER_EQUAL(">="),
        BINARY_AND("&"),
        BINARY_XOR("^"),
        BINARY_OR("|"),
        EQUALS("=="),
        NOT_EQUALS("!=");

        private final String op;

        private BinaryOperator(String pOp) {
            this.op = pOp;
        }

        @Override
        public String getOperator() {
            return this.op;
        }
    }
}

