/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

public class CBinaryExpressionBuilder {
    public static final Set<CBinaryExpression.BinaryOperator> relationalOperators = Sets.immutableEnumSet((Enum)CBinaryExpression.BinaryOperator.EQUALS, (Enum[])new CBinaryExpression.BinaryOperator[]{CBinaryExpression.BinaryOperator.NOT_EQUALS, CBinaryExpression.BinaryOperator.LESS_THAN, CBinaryExpression.BinaryOperator.LESS_EQUAL, CBinaryExpression.BinaryOperator.GREATER_THAN, CBinaryExpression.BinaryOperator.GREATER_EQUAL});
    private static final Set<CBinaryExpression.BinaryOperator> shiftOperators = Sets.immutableEnumSet((Enum)CBinaryExpression.BinaryOperator.SHIFT_LEFT, (Enum[])new CBinaryExpression.BinaryOperator[]{CBinaryExpression.BinaryOperator.SHIFT_RIGHT});
    private static final Set<CBinaryExpression.BinaryOperator> additiveOperators = Sets.immutableEnumSet((Enum)CBinaryExpression.BinaryOperator.PLUS, (Enum[])new CBinaryExpression.BinaryOperator[]{CBinaryExpression.BinaryOperator.MINUS});
    private static final Set<CBinaryExpression.BinaryOperator> multiplicativeOperators = Sets.immutableEnumSet((Enum)CBinaryExpression.BinaryOperator.MULTIPLY, (Enum[])new CBinaryExpression.BinaryOperator[]{CBinaryExpression.BinaryOperator.MODULO, CBinaryExpression.BinaryOperator.DIVIDE});
    private static final Set<CBinaryExpression.BinaryOperator> bitwiseOperators = Sets.immutableEnumSet((Enum)CBinaryExpression.BinaryOperator.BINARY_AND, (Enum[])new CBinaryExpression.BinaryOperator[]{CBinaryExpression.BinaryOperator.BINARY_OR, CBinaryExpression.BinaryOperator.BINARY_XOR});
    private final MachineModel machineModel;
    private final LogManager logger;

    public CBinaryExpressionBuilder(MachineModel pMachineModel, LogManager pLogger) {
        this.logger = pLogger;
        this.machineModel = pMachineModel;
    }

    public CBinaryExpression buildBinaryExpression(CExpression op1, CExpression op2, CBinaryExpression.BinaryOperator op) throws UnrecognizedCCodeException {
        CType calculationType;
        CType resultType;
        CType t1 = op1.getExpressionType().getCanonicalType();
        CType t2 = op2.getExpressionType().getCanonicalType();
        t1 = this.handleEnum(t1);
        t2 = this.handleEnum(t2);
        if (t1 instanceof CProblemType) {
            calculationType = resultType = t1;
        } else if (t2 instanceof CProblemType) {
            calculationType = resultType = t2;
        } else {
            calculationType = this.getCalculationTypeForBinaryOperation(t1, t2, op, op1, op2);
            resultType = this.getResultTypeForBinaryOperation(t1, t2, op, op1, op2);
        }
        return new CBinaryExpression(op1.getFileLocation(), resultType, calculationType, op1, op2, op);
    }

    public CBinaryExpression buildBinaryExpressionUnchecked(CExpression op1, CExpression op2, CBinaryExpression.BinaryOperator op) {
        try {
            return this.buildBinaryExpression(op1, op2, op);
        }
        catch (UnrecognizedCCodeException e) {
            throw new RuntimeException(e);
        }
    }

    private CType handleEnum(CType pType) {
        if (pType instanceof CEnumType || pType instanceof CElaboratedType && ((CElaboratedType)pType).getKind() == CComplexType.ComplexTypeKind.ENUM) {
            return CNumericTypes.SIGNED_INT;
        }
        return pType;
    }

    @VisibleForTesting
    CType getResultTypeForBinaryOperation(CType pType1, CType pType2, CBinaryExpression.BinaryOperator pBinOperator, CExpression op1, CExpression op2) throws UnrecognizedCCodeException {
        if (relationalOperators.contains(pBinOperator)) {
            return CNumericTypes.SIGNED_INT;
        }
        if (shiftOperators.contains(pBinOperator)) {
            CBinaryExpressionBuilder.checkIntegerType(pType1, pBinOperator, op1);
            CBinaryExpressionBuilder.checkIntegerType(pType2, pBinOperator, op2);
            return this.machineModel.getPromotedCType((CSimpleType)pType1);
        }
        if (bitwiseOperators.contains(pBinOperator)) {
            CBinaryExpressionBuilder.checkIntegerType(pType1, pBinOperator, op1);
            CBinaryExpressionBuilder.checkIntegerType(pType2, pBinOperator, op2);
        }
        return this.getCalculationTypeForBinaryOperation(pType1, pType2, pBinOperator, op1, op2);
    }

    @VisibleForTesting
    CType getCalculationTypeForBinaryOperation(CType pType1, CType pType2, CBinaryExpression.BinaryOperator pBinOperator, CExpression op1, CExpression op2) throws UnrecognizedCCodeException {
        if (shiftOperators.contains(pBinOperator)) {
            CBinaryExpressionBuilder.checkIntegerType(pType1, pBinOperator, op1);
            CBinaryExpressionBuilder.checkIntegerType(pType2, pBinOperator, op2);
            return this.machineModel.getPromotedCType((CSimpleType)pType1);
        }
        if (pType1 instanceof CSimpleType && pType2 instanceof CSimpleType) {
            CSimpleType commonType = this.getCommonSimpleTypeForBinaryOperation((CSimpleType)pType1, (CSimpleType)pType2);
            this.logger.logf(Level.ALL, "type-conversion: %s (%s, %s) -> %s", new Object[]{pBinOperator, pType1, pType2, commonType});
            return commonType;
        }
        if (pType1 instanceof CSimpleType) {
            return this.getSecondTypeToSimpleType(pType2, pBinOperator, op1, op2);
        }
        if (pType2 instanceof CSimpleType) {
            return this.getSecondTypeToSimpleType(pType1, pBinOperator, op1, op2);
        }
        if ((pType1 instanceof CPointerType || pType1 instanceof CFunctionType || pType1 instanceof CArrayType) && (pType2 instanceof CPointerType || pType2 instanceof CFunctionType || pType2 instanceof CArrayType)) {
            if (pBinOperator == CBinaryExpression.BinaryOperator.MINUS) {
                return this.machineModel.getPointerDiffType();
            }
            if (!relationalOperators.contains(pBinOperator)) {
                throw new UnrecognizedCCodeException("Operator " + pBinOperator + " cannot be used with two pointer operands", CBinaryExpressionBuilder.getDummyBinExprForLogging(pBinOperator, op1, op2));
            }
            if (pType1 instanceof CPointerType && pType2 instanceof CFunctionType) {
                if (((CPointerType)pType1).getType() instanceof CFunctionType) {
                    return pType1;
                }
            } else if (pType2 instanceof CPointerType && pType1 instanceof CFunctionType && ((CPointerType)pType2).getType() instanceof CFunctionType) {
                return pType2;
            }
            if (pType1.equals(pType2)) {
                return pType1;
            }
            this.logger.logf(Level.FINEST, "using calculationtype POINTER_TO_VOID for %s (%s, %s) of (%s, %s)", new Object[]{pBinOperator, pType1, pType2, pType1.getClass(), pType2.getClass()});
            return CPointerType.POINTER_TO_VOID;
        }
        if (pType1 instanceof CCompositeType || pType1 instanceof CElaboratedType || pType2 instanceof CCompositeType || pType2 instanceof CElaboratedType) {
            throw new UnrecognizedCCodeException("Operator " + pBinOperator + " cannot be used with composite-type operand", CBinaryExpressionBuilder.getDummyBinExprForLogging(pBinOperator, op1, op2));
        }
        throw new AssertionError((Object)String.format("unhandled type-conversion: %s (%s, %s) of (%s, %s)", pBinOperator, pType1, pType2, pType1.getClass(), pType2.getClass()));
    }

    private CType getSecondTypeToSimpleType(CType pType, CBinaryExpression.BinaryOperator pBinOperator, CExpression op1, CExpression op2) throws UnrecognizedCCodeException {
        if (pType instanceof CPointerType) {
            if (!additiveOperators.contains(pBinOperator) && !relationalOperators.contains(pBinOperator)) {
                throw new UnrecognizedCCodeException("Operator " + pBinOperator + " cannot be used with pointer operand", CBinaryExpressionBuilder.getDummyBinExprForLogging(pBinOperator, op1, op2));
            }
            return pType;
        }
        if (pType instanceof CArrayType) {
            if (!additiveOperators.contains(pBinOperator) && !relationalOperators.contains(pBinOperator)) {
                throw new UnrecognizedCCodeException("Operator " + pBinOperator + " cannot be used with array operand", CBinaryExpressionBuilder.getDummyBinExprForLogging(pBinOperator, op1, op2));
            }
            CArrayType at = (CArrayType)pType;
            return new CPointerType(at.isConst(), at.isVolatile(), at.getType());
        }
        if (pType instanceof CProblemType) {
            return CNumericTypes.SIGNED_INT;
        }
        throw new AssertionError((Object)("unhandled type (secondtype to simple type): " + pType));
    }

    private CSimpleType getCommonSimpleTypeForBinaryOperation(CSimpleType t1, CSimpleType t2) {
        assert (t1.equals(t1.getCanonicalType()) && t2.equals(t2.getCanonicalType()));
        if (t1.getType() == CBasicType.DOUBLE && t1.isLong()) {
            return t1;
        }
        if (t2.getType() == CBasicType.DOUBLE && t2.isLong()) {
            return t2;
        }
        if (t1.getType() == CBasicType.DOUBLE) {
            return t1;
        }
        if (t2.getType() == CBasicType.DOUBLE) {
            return t2;
        }
        if (t1.getType() == CBasicType.FLOAT) {
            return t1;
        }
        if (t2.getType() == CBasicType.FLOAT) {
            return t2;
        }
        return this.getLongestIntegerPromotion(t1, t2);
    }

    private CSimpleType getLongestIntegerPromotion(CSimpleType t1, CSimpleType t2) {
        assert (t1.getType() != CBasicType.INT || t1.isUnsigned() ^ t1.isSigned()) : "INT must be signed xor unsigned: " + t1;
        assert (t2.getType() != CBasicType.INT || t2.isUnsigned() ^ t2.isSigned()) : "INT must be signed xor unsigned: " + t2;
        assert (!t1.isLong() || !t1.isLongLong()) : "type cannot be long and longlong: " + t1;
        assert (!t2.isLong() || !t2.isLongLong()) : "type cannot be long and longlong: " + t2;
        t1 = this.machineModel.getPromotedCType(t1);
        t2 = this.machineModel.getPromotedCType(t2);
        int rank1 = CBinaryExpressionBuilder.getConversionRank(t1);
        int rank2 = CBinaryExpressionBuilder.getConversionRank(t2);
        if (t1.isUnsigned() == t2.isUnsigned()) {
            assert (t1.isSigned() == t2.isSigned());
            return rank1 > rank2 ? t1 : t2;
        }
        int size1 = this.machineModel.getSizeof(t1);
        int size2 = this.machineModel.getSizeof(t2);
        if (t1.isUnsigned() && rank1 >= rank2) {
            return t1;
        }
        if (t2.isUnsigned() && rank2 >= rank1) {
            return t2;
        }
        if (t1.isSigned() && size1 > size2) {
            return t1;
        }
        if (t2.isSigned() && size2 > size1) {
            return t2;
        }
        if (t1.isSigned()) {
            return new CSimpleType(false, false, CBasicType.INT, t1.isLong(), false, false, true, false, false, t1.isLongLong());
        }
        if (t2.isSigned()) {
            return new CSimpleType(false, false, CBasicType.INT, t2.isLong(), false, false, true, false, false, t2.isLongLong());
        }
        throw new AssertionError((Object)("unhandled type: " + t1 + " or " + t2));
    }

    private static int getConversionRank(CSimpleType t) {
        CBasicType type = t.getType();
        switch (type) {
            case BOOL: {
                return 10;
            }
            case CHAR: {
                return 20;
            }
            case INT: {
                if (t.isShort()) {
                    return 30;
                }
                if (t.isLong()) {
                    return 50;
                }
                if (t.isLongLong()) {
                    return 60;
                }
                return 40;
            }
        }
        throw new AssertionError((Object)("unhandled CSimpleType: " + t));
    }

    private static CBinaryExpression getDummyBinExprForLogging(CBinaryExpression.BinaryOperator pBinOperator, CExpression op1, CExpression op2) {
        return new CBinaryExpression(op1.getFileLocation(), null, null, op1, op2, pBinOperator);
    }

    private static void checkIntegerType(CType pType, CBinaryExpression.BinaryOperator op, CExpression e) throws UnrecognizedCCodeException {
        if (!((CSimpleType)pType).getType().isIntegerType()) {
            throw new UnrecognizedCCodeException("Operator " + op + " needs integer type, but is used with " + pType, e);
        }
    }
}

