/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractInitializer;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerVisitor;

public class CDesignatedInitializer
extends AbstractInitializer
implements CInitializer {
    private final List<CDesignator> designators;
    private final CInitializer right;

    public CDesignatedInitializer(FileLocation pFileLocation, List<CDesignator> pLeft, CInitializer pRight) {
        super(pFileLocation);
        this.designators = ImmutableList.copyOf(pLeft);
        this.right = pRight;
    }

    @Override
    public String toASTString() {
        return FluentIterable.from(this.designators).transform(CDesignator.TO_AST_STRING).join(Joiner.on((String)"")) + " = " + this.right.toASTString();
    }

    public List<CDesignator> getDesignators() {
        return this.designators;
    }

    public CInitializer getRightHandSide() {
        return this.right;
    }

    @Override
    public <R, X extends Exception> R accept(CInitializerVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.designators);
        result = 31 * result + Objects.hashCode(this.right);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CDesignatedInitializer) || !super.equals(obj)) {
            return false;
        }
        CDesignatedInitializer other = (CDesignatedInitializer)obj;
        return Objects.equals(other.designators, this.designators) && Objects.equals(other.right, this.right);
    }
}

