/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public final class CFieldReference
extends AbstractExpression
implements CLeftHandSide {
    private final String name;
    private final CExpression owner;
    private final boolean isPointerDereference;

    public CFieldReference(FileLocation pFileLocation, CType pType, String pName, CExpression pOwner, boolean pIsPointerDereference) {
        super(pFileLocation, pType);
        this.name = pName;
        this.owner = pOwner;
        this.isPointerDereference = pIsPointerDereference;
        assert (this.checkFieldAccess());
    }

    private boolean checkFieldAccess() throws IllegalArgumentException {
        CType structType = this.owner.getExpressionType().getCanonicalType();
        if (structType instanceof CCompositeType) {
            boolean found = false;
            for (CCompositeType.CCompositeTypeMemberDeclaration field : ((CCompositeType)structType).getMembers()) {
                if (!field.getName().equals(this.name)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("Accessing unknown field " + this.name + " in " + structType);
            }
        }
        return true;
    }

    @Override
    public CType getExpressionType() {
        return (CType)super.getExpressionType();
    }

    public String getFieldName() {
        return this.name;
    }

    public CExpression getFieldOwner() {
        return this.owner;
    }

    public boolean isPointerDereference() {
        return this.isPointerDereference;
    }

    @Override
    public <R, X extends Exception> R accept(CExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CLeftHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public String toASTString() {
        String left = this.owner instanceof CFieldReference ? this.owner.toASTString() : this.owner.toParenthesizedASTString();
        String op = this.isPointerDereference ? "->" : ".";
        return left + op + this.name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + (this.isPointerDereference ? 1231 : 1237);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.owner);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CFieldReference) || !super.equals(obj)) {
            return false;
        }
        CFieldReference other = (CFieldReference)obj;
        return Objects.equals(other.isPointerDereference, this.isPointerDereference) && Objects.equals(other.name, this.name) && Objects.equals(other.owner, this.owner);
    }
}

