/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;

public class CIdExpressionCollectorVisitor
extends DefaultCExpressionVisitor<Void, RuntimeException> {
    private final Set<CIdExpression> referencedVariables = new HashSet<CIdExpression>();

    public static Set<String> getVariablesOfExpression(CExpression expr) {
        HashSet<String> result = new HashSet<String>();
        CIdExpressionCollectorVisitor collector = new CIdExpressionCollectorVisitor();
        expr.accept(collector);
        for (CIdExpression id : collector.getReferencedIdExpressions()) {
            String assignToVar = id.getDeclaration().getQualifiedName();
            result.add(assignToVar);
        }
        return result;
    }

    public Set<CIdExpression> getReferencedIdExpressions() {
        return this.referencedVariables;
    }

    @Override
    protected Void visitDefault(CExpression pExp) {
        return null;
    }

    @Override
    public Void visit(CIdExpression pIastIdExpression) {
        this.referencedVariables.add(pIastIdExpression);
        return null;
    }

    @Override
    public Void visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
        pIastArraySubscriptExpression.getArrayExpression().accept(this);
        pIastArraySubscriptExpression.getSubscriptExpression().accept(this);
        return null;
    }

    @Override
    public Void visit(CBinaryExpression pIastBinaryExpression) {
        pIastBinaryExpression.getOperand1().accept(this);
        pIastBinaryExpression.getOperand2().accept(this);
        return null;
    }

    @Override
    public Void visit(CCastExpression pIastCastExpression) {
        return pIastCastExpression.getOperand().accept(this);
    }

    @Override
    public Void visit(CComplexCastExpression pIastCastExpression) {
        return pIastCastExpression.getOperand().accept(this);
    }

    @Override
    public Void visit(CFieldReference pIastFieldReference) {
        return pIastFieldReference.getFieldOwner().accept(this);
    }

    @Override
    public Void visit(CUnaryExpression pIastUnaryExpression) {
        return pIastUnaryExpression.getOperand().accept(this);
    }

    @Override
    public Void visit(CPointerExpression pIastUnaryExpression) {
        return pIastUnaryExpression.getOperand().accept(this);
    }
}

