/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractInitializer;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerVisitor;

public class CInitializerList
extends AbstractInitializer
implements CInitializer,
CAstNode {
    private final List<CInitializer> initializerList;

    public CInitializerList(FileLocation pFileLocation, List<CInitializer> pInitializerList) {
        super(pFileLocation);
        this.initializerList = ImmutableList.copyOf(pInitializerList);
    }

    public List<CInitializer> getInitializers() {
        return this.initializerList;
    }

    @Override
    public String toASTString() {
        StringBuilder lASTString = new StringBuilder();
        lASTString.append("{ ");
        Joiner.on((String)", ").appendTo(lASTString, Iterables.transform(this.initializerList, (Function)CInitializer.TO_AST_STRING));
        lASTString.append(" }");
        return lASTString.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.initializerList);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CInitializerList) || !super.equals(obj)) {
            return false;
        }
        CInitializerList other = (CInitializerList)obj;
        return Objects.equals(other.initializerList, this.initializerList);
    }

    @Override
    public <R, X extends Exception> R accept(CInitializerVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }
}

