/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

public final class CInitializers {
    private CInitializers() {
    }

    public static List<CExpressionAssignmentStatement> convertToAssignments(CVariableDeclaration decl, CFAEdge edge) throws UnrecognizedCCodeException {
        CInitializer init = decl.getInitializer();
        if (init == null) {
            return ImmutableList.of();
        }
        CIdExpression lhs = new CIdExpression(decl.getFileLocation(), decl);
        if (init instanceof CInitializerExpression) {
            CExpression initExp = ((CInitializerExpression)init).getExpression();
            CExpressionAssignmentStatement assignment = new CExpressionAssignmentStatement(decl.getFileLocation(), lhs, initExp);
            return ImmutableList.of((Object)assignment);
        }
        if (init instanceof CInitializerList) {
            return CInitializers.handleInitializerList(lhs, (CInitializerList)init, decl.getFileLocation(), edge);
        }
        throw new UnrecognizedCCodeException("Unknown initializer type", edge, init);
    }

    private static List<CExpressionAssignmentStatement> handleInitializerList(CExpression currentObject, CInitializerList initializerList, FileLocation loc, CFAEdge edge) throws UnrecognizedCCodeException {
        boolean successful;
        ArrayDeque<CExpression> currentSubobjects = new ArrayDeque<CExpression>(2);
        ArrayDeque<Iterator<CExpression>> nextSubobjects = new ArrayDeque<Iterator<CExpression>>(2);
        currentSubobjects.push(currentObject);
        CType currentType = currentObject.getExpressionType().getCanonicalType();
        if (currentType instanceof CCompositeType && ((CCompositeType)currentType).getKind() != CComplexType.ComplexTypeKind.ENUM) {
            successful = CInitializers.handleInitializerForCompositeType(currentObject, (Optional<String>)Optional.absent(), (CCompositeType)currentType, currentSubobjects, nextSubobjects, loc, edge, null);
        } else if (currentType instanceof CArrayType) {
            successful = CInitializers.handleInitializerForArray(currentObject, 0L, (CArrayType)currentType, currentSubobjects, nextSubobjects, loc, edge, null);
        } else {
            if (currentType instanceof CElaboratedType) {
                throw new UnrecognizedCCodeException("Unexpected initializer for " + currentType + " that is not fully defined", edge, initializerList);
            }
            throw new UnrecognizedCCodeException("Unexpected initializer list for " + currentObject + " with type " + currentType, edge, initializerList);
        }
        if (!successful) {
            if (!initializerList.getInitializers().isEmpty()) {
                throw new UnrecognizedCCodeException("Too many values in initializer list", edge, initializerList);
            }
            return ImmutableList.of();
        }
        ArrayList<CExpressionAssignmentStatement> result = new ArrayList<CExpressionAssignmentStatement>(initializerList.getInitializers().size());
        for (CInitializer init : initializerList.getInitializers()) {
            if (init instanceof CDesignatedInitializer) {
                CInitializers.findDesignatedSubobject(((CDesignatedInitializer)init).getDesignators(), currentObject, currentSubobjects, nextSubobjects, loc, edge);
                init = ((CDesignatedInitializer)init).getRightHandSide();
                if (init instanceof CDesignatedInitializer) {
                    throw new UnrecognizedCCodeException("Too complex struct initializer", edge, initializerList);
                }
            }
            if (currentSubobjects.isEmpty()) {
                throw new UnrecognizedCCodeException("Too many values in initializer list", edge, initializerList);
            }
            if (init instanceof CInitializerList) {
                CExpression currentSubobject = (CExpression)currentSubobjects.pop();
                result.addAll(CInitializers.handleInitializerList(currentSubobject, (CInitializerList)init, loc, edge));
            } else if (init instanceof CInitializerExpression) {
                CExpression initExp = ((CInitializerExpression)init).getExpression();
                CType initType = initExp.getExpressionType().getCanonicalType();
                CInitializers.findFirstSubobjectWithType(initType, currentSubobjects, nextSubobjects, loc, edge);
                assert (currentSubobjects.peek() instanceof CLeftHandSide) : "Object hast to be a LeftHandSide";
                CLeftHandSide currentSubobject = (CLeftHandSide)currentSubobjects.pop();
                CExpressionAssignmentStatement assignment = new CExpressionAssignmentStatement(loc, currentSubobject, initExp);
                result.add(assignment);
            } else {
                throw new UnrecognizedCCodeException("Unknown initializer type", edge, init);
            }
            while (!nextSubobjects.isEmpty() && !((Iterator)nextSubobjects.peek()).hasNext()) {
                nextSubobjects.pop();
                currentSubobjects.pop();
            }
            if (nextSubobjects.isEmpty()) continue;
            currentSubobjects.push((CExpression)((Iterator)nextSubobjects.peek()).next());
        }
        return result;
    }

    private static void findDesignatedSubobject(List<CDesignator> designators, CExpression currentObject, Deque<CExpression> currentSubobjects, Deque<Iterator<CExpression>> nextSubobjects, FileLocation loc, CFAEdge edge) throws UnrecognizedCCodeException {
        currentSubobjects.clear();
        nextSubobjects.clear();
        currentSubobjects.push(currentObject);
        for (CDesignator designator : designators) {
            CArrayType arrayType;
            boolean successful;
            CExpression currentSubobject = currentSubobjects.peek();
            CType currentType = currentSubobject.getExpressionType().getCanonicalType();
            if (designator instanceof CFieldDesignator) {
                String fieldName = ((CFieldDesignator)designator).getFieldName();
                if (!(currentType instanceof CCompositeType) || ((CCompositeType)currentType).getKind() == CComplexType.ComplexTypeKind.ENUM) {
                    throw new UnrecognizedCCodeException("Designated field initializer for non-struct type " + currentType, edge, designator);
                }
                successful = CInitializers.handleInitializerForCompositeType(currentSubobject, (Optional<String>)Optional.of((Object)fieldName), (CCompositeType)currentType, currentSubobjects, nextSubobjects, loc, edge, designator);
            } else if (designator instanceof CArrayDesignator) {
                if (!(currentType instanceof CArrayType)) {
                    throw new UnrecognizedCCodeException("Designated array initializer for non-array type " + currentType, edge, designator);
                }
                arrayType = (CArrayType)currentType;
                CExpression indexExp = ((CArrayDesignator)designator).getSubscriptExpression();
                if (!(indexExp instanceof CIntegerLiteralExpression)) {
                    throw new UnrecognizedCCodeException("Cannot evaluate expression as array designator", edge, designator);
                }
                BigInteger index = ((CIntegerLiteralExpression)indexExp).getValue();
                if (!BigInteger.valueOf(index.longValue()).equals(index)) {
                    throw new UnrecognizedCCodeException("Array designator is too large to initialize explicitly", edge, designator);
                }
                successful = CInitializers.handleInitializerForArray(currentSubobject, index.longValue(), arrayType, currentSubobjects, nextSubobjects, loc, edge, designator);
            } else if (designator instanceof CArrayRangeDesignator) {
                if (!(currentType instanceof CArrayType)) {
                    throw new UnrecognizedCCodeException("Designated array initializer for non-array type " + currentType, edge, designator);
                }
                arrayType = (CArrayType)currentType;
                CExpression floorExp = ((CArrayRangeDesignator)designator).getFloorExpression();
                CExpression ceilExp = ((CArrayRangeDesignator)designator).getCeilExpression();
                if (!(floorExp instanceof CIntegerLiteralExpression) || !(ceilExp instanceof CIntegerLiteralExpression)) {
                    throw new UnrecognizedCCodeException("Cannot evaluate expression as array range designator", edge, designator);
                }
                BigInteger indexBottom = ((CIntegerLiteralExpression)floorExp).getValue();
                BigInteger indexTop = ((CIntegerLiteralExpression)ceilExp).getValue();
                if (!BigInteger.valueOf(indexBottom.longValue()).equals(indexBottom) || !BigInteger.valueOf(indexTop.longValue()).equals(indexTop)) {
                    throw new UnrecognizedCCodeException("Array range designator is too large to initialize explicitly", edge, designator);
                }
                successful = true;
                for (long index = indexBottom.longValue(); index < indexTop.longValue() && successful; ++index) {
                    successful = CInitializers.handleInitializerForArray(currentSubobject, index, arrayType, currentSubobjects, nextSubobjects, loc, edge, designator);
                }
            } else {
                throw new UnrecognizedCCodeException("Unrecognized initializer designator", edge, designator);
            }
            if (successful) continue;
            throw new UnrecognizedCCodeException("Empty struct or array is not supported as field", edge, currentSubobject);
        }
    }

    private static <T> Iterator<T> safeCast(Iterator<? extends T> it) {
        return it;
    }

    private static void findFirstSubobjectWithType(CType targetType, Deque<CExpression> currentSubobjects, Deque<Iterator<CExpression>> nextSubobjects, FileLocation loc, CFAEdge edge) throws UnrecognizedCCodeException {
        CType currentElementType;
        CExpression currentSubobject;
        CType currentType;
        while (!(targetType.equals(currentType = (currentSubobject = currentSubobjects.peek()).getExpressionType().getCanonicalType()) || targetType.equals(CPointerType.POINTER_TO_CONST_CHAR) && currentType instanceof CArrayType && (currentElementType = ((CArrayType)currentType).getType()) instanceof CSimpleType && ((CSimpleType)currentElementType).getType() == CBasicType.CHAR)) {
            boolean successful;
            if (currentType instanceof CCompositeType && ((CCompositeType)currentType).getKind() != CComplexType.ComplexTypeKind.ENUM) {
                successful = CInitializers.handleInitializerForCompositeType(currentSubobject, (Optional<String>)Optional.absent(), (CCompositeType)currentType, currentSubobjects, nextSubobjects, loc, edge, null);
            } else {
                if (!(currentType instanceof CArrayType)) break;
                successful = CInitializers.handleInitializerForArray(currentSubobject, 0L, (CArrayType)currentType, currentSubobjects, nextSubobjects, loc, edge, null);
            }
            if (successful) continue;
            throw new UnrecognizedCCodeException("Empty struct or array is not supported as field", edge, currentSubobject);
        }
    }

    private static boolean handleInitializerForCompositeType(final CExpression currentSubobject, Optional<String> startingFieldName, CCompositeType structType, Deque<CExpression> currentSubobjects, Deque<Iterator<CExpression>> nextSubobjects, final FileLocation loc, CFAEdge edge, CDesignator designator) throws UnrecognizedCCodeException {
        Iterator fields = FluentIterable.from(structType.getMembers()).transform((Function)new Function<CCompositeType.CCompositeTypeMemberDeclaration, CFieldReference>(){

            public CFieldReference apply(CCompositeType.CCompositeTypeMemberDeclaration field) {
                return new CFieldReference(loc, field.getType(), field.getName(), currentSubobject, false);
            }
        }).iterator();
        if (!fields.hasNext()) {
            return false;
        }
        CFieldReference designatedField = null;
        if (startingFieldName.isPresent()) {
            while (fields.hasNext()) {
                CFieldReference f = (CFieldReference)fields.next();
                if (!f.getFieldName().equals(startingFieldName.get())) continue;
                designatedField = f;
                break;
            }
            if (designatedField == null) {
                throw new UnrecognizedCCodeException("Initializer for field " + (String)startingFieldName.get() + " but no field with this name exists in " + structType, edge, designator);
            }
        } else {
            designatedField = (CFieldReference)fields.next();
        }
        currentSubobjects.push(designatedField);
        switch (structType.getKind()) {
            case STRUCT: {
                nextSubobjects.push(CInitializers.safeCast(fields));
                break;
            }
            case UNION: {
                nextSubobjects.push(Collections.emptyIterator());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return true;
    }

    private static boolean handleInitializerForArray(final CExpression currentSubobject, long startIndex, CArrayType arrayType, Deque<CExpression> currentSubobjects, Deque<Iterator<CExpression>> nextSubobjects, final FileLocation loc, CFAEdge edge, CDesignator designator) throws UnrecognizedCCodeException {
        Range arrayIndices;
        if (arrayType.getLength() instanceof CIntegerLiteralExpression) {
            BigInteger size = ((CIntegerLiteralExpression)arrayType.getLength()).getValue();
            if (!BigInteger.valueOf(size.longValue()).equals(size)) {
                throw new UnrecognizedCCodeException("Size of type " + arrayType + " is too large to initialize explicitly", edge, designator);
            }
            arrayIndices = Range.closedOpen((Comparable)Long.valueOf(startIndex), (Comparable)Long.valueOf(size.longValue()));
        } else if (arrayType.getLength() == null) {
            arrayIndices = Range.atLeast((Comparable)Long.valueOf(startIndex));
        } else {
            throw new UnrecognizedCCodeException("Cannot initialize arrays with variable modified type like " + arrayType, edge, designator);
        }
        if (arrayIndices.isEmpty()) {
            return false;
        }
        final CType elementType = arrayType.getType();
        ContiguousSet indexSet = ContiguousSet.create((Range)arrayIndices, (DiscreteDomain)DiscreteDomain.longs());
        Iterator elements = FluentIterable.from((Iterable)indexSet).transform((Function)new Function<Long, CExpression>(){

            public CExpression apply(Long pInput) {
                CIntegerLiteralExpression index = new CIntegerLiteralExpression(loc, CNumericTypes.INT, BigInteger.valueOf(pInput));
                return new CArraySubscriptExpression(loc, elementType, currentSubobject, index);
            }
        }).iterator();
        CExpression firstElement = (CExpression)elements.next();
        currentSubobjects.push(firstElement);
        nextSubobjects.push(elements);
        return true;
    }
}

