/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public final class CTypeIdExpression
extends AbstractExpression
implements CExpression {
    private final TypeIdOperator operator;
    private final CType type;

    public CTypeIdExpression(FileLocation pFileLocation, CType pExpressionType, TypeIdOperator pOperator, CType pType) {
        super(pFileLocation, pExpressionType);
        this.operator = pOperator;
        this.type = pType;
    }

    @Override
    public CType getExpressionType() {
        return (CType)super.getExpressionType();
    }

    public TypeIdOperator getOperator() {
        return this.operator;
    }

    public CType getType() {
        return this.type;
    }

    @Override
    public <R, X extends Exception> R accept(CExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public String toASTString() {
        return this.operator.getOperator() + "(" + this.type.toASTString("") + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode((Object)this.operator);
        result = 31 * result + Objects.hashCode(this.type);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CTypeIdExpression) || !super.equals(obj)) {
            return false;
        }
        CTypeIdExpression other = (CTypeIdExpression)obj;
        return Objects.equals((Object)other.operator, (Object)this.operator) && Objects.equals(other.type, this.type);
    }

    public static enum TypeIdOperator {
        SIZEOF,
        TYPEID,
        ALIGNOF,
        TYPEOF;


        public String getOperator() {
            return this.toString().toLowerCase();
        }
    }
}

