/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;

public class FileLocationCollectingVisitor
implements CAstNodeVisitor<Set<FileLocation>, RuntimeException> {
    @Override
    public Set<FileLocation> visit(CArraySubscriptExpression pE) {
        return Sets.union(Collections.singleton(pE.getFileLocation()), (Set)Sets.union(pE.getArrayExpression().accept(this), pE.getSubscriptExpression().accept(this)));
    }

    @Override
    public Set<FileLocation> visit(CBinaryExpression pE) {
        return Sets.union(Collections.singleton(pE.getFileLocation()), (Set)Sets.union(pE.getOperand1().accept(this), pE.getOperand2().accept(this)));
    }

    @Override
    public Set<FileLocation> visit(CCastExpression pE) {
        return Sets.union(Collections.singleton(pE.getFileLocation()), pE.getOperand().accept(this));
    }

    @Override
    public Set<FileLocation> visit(CComplexCastExpression pE) {
        return Sets.union(Collections.singleton(pE.getFileLocation()), pE.getOperand().accept(this));
    }

    @Override
    public Set<FileLocation> visit(CFieldReference pE) {
        return Sets.union(Collections.singleton(pE.getFileLocation()), pE.getFieldOwner().accept(this));
    }

    @Override
    public Set<FileLocation> visit(CPointerExpression pE) {
        return Sets.union(Collections.singleton(pE.getFileLocation()), pE.getOperand().accept(this));
    }

    @Override
    public Set<FileLocation> visit(CUnaryExpression pE) {
        return Sets.union(Collections.singleton(pE.getFileLocation()), pE.getOperand().accept(this));
    }

    @Override
    public Set<FileLocation> visit(CInitializerExpression pE) {
        return Sets.union(Collections.singleton(pE.getFileLocation()), pE.getExpression().accept(this));
    }

    @Override
    public Set<FileLocation> visit(CInitializerList pI) {
        HashSet result = Sets.newHashSet();
        result.add(pI.getFileLocation());
        for (CInitializer i : pI.getInitializers()) {
            result.add(i.getFileLocation());
            result.addAll((Collection)i.accept(this));
        }
        return result;
    }

    @Override
    public Set<FileLocation> visit(CDesignatedInitializer pI) {
        return Collections.singleton(pI.getFileLocation());
    }

    @Override
    public Set<FileLocation> visit(CExpressionAssignmentStatement pS) {
        return Sets.union(Collections.singleton(pS.getFileLocation()), (Set)Sets.union(pS.getLeftHandSide().accept(this), pS.getRightHandSide().accept(this)));
    }

    @Override
    public Set<FileLocation> visit(CExpressionStatement pS) {
        return Sets.union(Collections.singleton(pS.getFileLocation()), pS.getExpression().accept(this));
    }

    @Override
    public Set<FileLocation> visit(CFunctionCallAssignmentStatement pS) {
        HashSet result = Sets.newHashSet();
        result.add(pS.getFileLocation());
        result.addAll((Collection)pS.getLeftHandSide().accept(this));
        result.addAll((Collection)pS.getRightHandSide().accept(this));
        return result;
    }

    @Override
    public Set<FileLocation> visit(CFunctionCallStatement pS) {
        return Collections.singleton(pS.getFileLocation());
    }

    @Override
    public Set<FileLocation> visit(CIdExpression pE) {
        return Collections.singleton(pE.getFileLocation());
    }

    @Override
    public Set<FileLocation> visit(CCharLiteralExpression pE) {
        return Collections.singleton(pE.getFileLocation());
    }

    @Override
    public Set<FileLocation> visit(CFloatLiteralExpression pE) {
        if (pE.getFileLocation() != null) {
            return Collections.singleton(pE.getFileLocation());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<FileLocation> visit(CIntegerLiteralExpression pE) {
        if (pE.getFileLocation() != null) {
            return Collections.singleton(pE.getFileLocation());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<FileLocation> visit(CStringLiteralExpression pE) {
        return Collections.singleton(pE.getFileLocation());
    }

    @Override
    public Set<FileLocation> visit(CTypeIdExpression pE) {
        return Collections.singleton(pE.getFileLocation());
    }

    @Override
    public Set<FileLocation> visit(CImaginaryLiteralExpression pE) {
        return Collections.singleton(pE.getFileLocation());
    }

    public Set<FileLocation> collectLocationsFrom(CExpression astNode) {
        return astNode.accept(this);
    }

    public Set<FileLocation> collectLocationsFrom(CDeclaration astNode) {
        return astNode.accept(this);
    }

    public Set<FileLocation> collectLocationsFrom(CStatement astNode) {
        return astNode.accept(this);
    }

    public Set<FileLocation> collectLocationsFrom(CInitializer astNode) {
        return astNode.accept(this);
    }

    @Override
    public Set<FileLocation> visit(CFunctionDeclaration astNode) {
        HashSet result = Sets.newHashSet();
        result.add(astNode.getFileLocation());
        for (CParameterDeclaration expr : astNode.getParameters()) {
            result.addAll((Collection)expr.accept(this));
        }
        return result;
    }

    @Override
    public Set<FileLocation> visit(CVariableDeclaration astNode) {
        HashSet result = Sets.newHashSet();
        result.add(astNode.getFileLocation());
        if (astNode.getInitializer() != null) {
            result.addAll((Collection)astNode.getInitializer().accept(this));
        }
        return result;
    }

    @Override
    public Set<FileLocation> visit(CComplexTypeDeclaration pDecl) {
        return Collections.singleton(pDecl.getFileLocation());
    }

    @Override
    public Set<FileLocation> visit(CParameterDeclaration pDecl) {
        return Collections.singleton(pDecl.getFileLocation());
    }

    @Override
    public Set<FileLocation> visit(CEnumType.CEnumerator pDecl) {
        return Collections.singleton(pDecl.getFileLocation());
    }

    @Override
    public Set<FileLocation> visit(CArrayDesignator pNode) {
        Sets.SetView result = Collections.singleton(pNode.getFileLocation());
        if (pNode.getSubscriptExpression() != null) {
            result = Sets.union(result, pNode.getSubscriptExpression().accept(this));
        }
        return result;
    }

    @Override
    public Set<FileLocation> visit(CArrayRangeDesignator pNode) {
        Sets.SetView result = Collections.singleton(pNode.getFileLocation());
        if (pNode.getCeilExpression() != null) {
            result = Sets.union(result, pNode.getCeilExpression().accept(this));
        }
        if (pNode.getFloorExpression() != null) {
            result = Sets.union((Set)result, pNode.getFloorExpression().accept(this));
        }
        return result;
    }

    @Override
    public Set<FileLocation> visit(CFieldDesignator pNode) {
        return Collections.singleton(pNode.getFileLocation());
    }

    @Override
    public Set<FileLocation> visit(CReturnStatement pNode) {
        Sets.SetView result = Collections.singleton(pNode.getFileLocation());
        if (pNode.getReturnValue().isPresent()) {
            result = Sets.union(result, ((CExpression)pNode.getReturnValue().get()).accept(this));
        }
        return result;
    }

    @Override
    public Set<FileLocation> visit(CFunctionCallExpression pNode) {
        HashSet result = Sets.newHashSet();
        result.add(pNode.getFileLocation());
        result.addAll((Collection)pNode.getFunctionNameExpression().accept(this));
        for (CExpression expr : pNode.getParameterExpressions()) {
            result.addAll((Collection)expr.accept(this));
        }
        return result;
    }

    @Override
    public Set<FileLocation> visit(CTypeDefDeclaration pNode) {
        return Collections.singleton(pNode.getFileLocation());
    }

    @Override
    public Set<FileLocation> visit(CAddressOfLabelExpression pNode) {
        return Collections.singleton(pNode.getFileLocation());
    }
}

