/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.java;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayInitializer;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;

public class JArrayCreationExpression
extends AbstractExpression
implements JExpression {
    private final List<JExpression> length;
    private final JArrayInitializer initializer;

    public JArrayCreationExpression(FileLocation pFileLocation, JArrayType pType, JArrayInitializer pInitializer, List<JExpression> pLength) {
        super(pFileLocation, pType);
        this.length = ImmutableList.copyOf(pLength);
        this.initializer = pInitializer;
    }

    @Override
    public JArrayType getExpressionType() {
        return (JArrayType)super.getExpressionType();
    }

    @Override
    public <R, X extends Exception> R accept(JRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString() {
        if (this.initializer != null) {
            return this.initializer.toASTString();
        }
        StringBuilder astString = new StringBuilder("new " + this.getExpressionType().getElementType().toASTString(""));
        for (JExpression exp : this.length) {
            astString.append("[");
            astString.append(exp.toASTString());
            astString.append("]");
        }
        return astString.toString();
    }

    @Override
    public <R, X extends Exception> R accept(JExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    public List<JExpression> getLength() {
        return this.length;
    }

    public JArrayInitializer getInitializer() {
        return this.initializer;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.initializer);
        result = 31 * result + Objects.hashCode(this.length);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JArrayCreationExpression) || !super.equals(obj)) {
            return false;
        }
        JArrayCreationExpression other = (JArrayCreationExpression)obj;
        return Objects.equals(other.initializer, this.initializer) && Objects.equals(other.length, this.length);
    }
}

