/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.java;

import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JAstNode;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;

public abstract class JArrayLengthExpression
extends AbstractExpression
implements JExpression,
JAstNode,
JRightHandSide {
    private JArrayLengthExpression(FileLocation pFileLocation, JExpression pQualifier) {
        super(pFileLocation, JSimpleType.getInt());
    }

    public static JArrayLengthExpression getInstance(JExpression pQualifier, FileLocation pLocation) {
        if (pQualifier instanceof JArraySubscriptExpression) {
            return new JSubArrayLengthExpression(pLocation, (JArraySubscriptExpression)pQualifier);
        }
        if (pQualifier instanceof JIdExpression) {
            return new JTopArrayLengthExpression(pLocation, (JIdExpression)pQualifier);
        }
        throw new AssertionError((Object)("Unexpected expression " + pQualifier));
    }

    public abstract JExpression getQualifier();

    @Override
    public JSimpleType getExpressionType() {
        return (JSimpleType)super.getExpressionType();
    }

    @Override
    public <R, X extends Exception> R accept(JExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(JRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    private static class JTopArrayLengthExpression
    extends JArrayLengthExpression {
        private final JIdExpression qualifier;

        private JTopArrayLengthExpression(FileLocation pFileLocation, JIdExpression pQualifier) {
            super(pFileLocation, pQualifier);
            this.qualifier = pQualifier;
        }

        @Override
        public String toASTString() {
            return this.qualifier + ".length";
        }

        @Override
        public JIdExpression getQualifier() {
            return this.qualifier;
        }
    }

    private static class JSubArrayLengthExpression
    extends JArrayLengthExpression {
        private final JArraySubscriptExpression qualifier;

        public JSubArrayLengthExpression(FileLocation pFileLocation, JArraySubscriptExpression pQualifier) {
            super(pFileLocation, pQualifier);
            this.qualifier = pQualifier;
        }

        @Override
        public String toASTString() {
            return this.qualifier + ".length";
        }

        @Override
        public JArraySubscriptExpression getQualifier() {
            return this.qualifier;
        }
    }
}

