/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.java;

import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

public class JMethodInvocationExpression
extends AFunctionCallExpression
implements JRightHandSide {
    private boolean hasKnownRunTimeBinding = false;
    private JClassType runTimeBinding = null;

    public JMethodInvocationExpression(FileLocation pFileLocation, JType pType, JExpression pFunctionName, List<? extends JExpression> pParameters, JMethodDeclaration pDeclaration) {
        super(pFileLocation, pType, pFunctionName, pParameters, pDeclaration);
    }

    @Override
    public JExpression getFunctionNameExpression() {
        return (JExpression)super.getFunctionNameExpression();
    }

    @Override
    public JType getExpressionType() {
        return (JType)super.getExpressionType();
    }

    @Override
    public JMethodDeclaration getDeclaration() {
        return (JMethodDeclaration)super.getDeclaration();
    }

    public List<? extends JExpression> getParameterExpressions() {
        return super.getParameterExpressions();
    }

    @Override
    public <R, X extends Exception> R accept(JRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    public JClassOrInterfaceType getDeclaringType() {
        return this.getDeclaration().getDeclaringClass();
    }

    public JClassType getRunTimeBinding() {
        return this.runTimeBinding;
    }

    public void setRunTimeBinding(JClassType runTimeBinding) {
        this.runTimeBinding = runTimeBinding;
        this.hasKnownRunTimeBinding = true;
    }

    public boolean hasKnownRunTimeBinding() {
        return this.hasKnownRunTimeBinding;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + (this.hasKnownRunTimeBinding ? 1231 : 1237);
        result = 31 * result + Objects.hashCode(this.runTimeBinding);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JMethodInvocationExpression) || !super.equals(obj)) {
            return false;
        }
        JMethodInvocationExpression other = (JMethodInvocationExpression)obj;
        return other.hasKnownRunTimeBinding == this.hasKnownRunTimeBinding && Objects.equals(other.runTimeBinding, this.runTimeBinding);
    }
}

