/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.java;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeExpression;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

public class JRunTimeTypeEqualsType
extends AbstractExpression
implements JExpression {
    private final JRunTimeTypeExpression runTimeTypeExpression;
    private final JClassOrInterfaceType typeDef;

    public JRunTimeTypeEqualsType(FileLocation pFileLocation, JRunTimeTypeExpression pRunTimeTypeExpression, JClassOrInterfaceType pTypeDef) {
        super(pFileLocation, JSimpleType.getBoolean());
        this.runTimeTypeExpression = pRunTimeTypeExpression;
        this.typeDef = pTypeDef;
        assert (this.getRunTimeTypeExpression() != null);
        assert (this.getTypeDef() != null);
    }

    @Override
    public JType getExpressionType() {
        return (JType)super.getExpressionType();
    }

    @Override
    public <R, X extends Exception> R accept(JRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(JExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString() {
        StringBuilder astString = new StringBuilder("(");
        astString.append(this.getRunTimeTypeExpression().toASTString());
        astString.append("_equals(");
        astString.append(this.getTypeDef().getName());
        astString.append("))");
        return astString.toString();
    }

    public JClassOrInterfaceType getTypeDef() {
        return this.typeDef;
    }

    public JRunTimeTypeExpression getRunTimeTypeExpression() {
        return this.runTimeTypeExpression;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.runTimeTypeExpression);
        result = 31 * result + Objects.hashCode(this.typeDef);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JRunTimeTypeEqualsType) || !super.equals(obj)) {
            return false;
        }
        JRunTimeTypeEqualsType other = (JRunTimeTypeEqualsType)obj;
        return Objects.equals(other.runTimeTypeExpression, this.runTimeTypeExpression) && Objects.equals(other.typeDef, this.typeDef);
    }
}

