/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.java;

import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JDeclaration;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

public class JVariableDeclaration
extends AVariableDeclaration
implements JDeclaration {
    private static final boolean IS_LOCAL = false;
    private final boolean isFinal;

    protected JVariableDeclaration(FileLocation pFileLocation, boolean pIsGlobal, JType pType, String pName, String pOrigName, String pQualifiedName, AInitializer pInitializer, boolean pIsFinal) {
        super(pFileLocation, pIsGlobal, pType, pName, pOrigName, pQualifiedName, pInitializer);
        this.isFinal = pIsFinal;
    }

    public JVariableDeclaration(FileLocation pFileLocation, JType pType, String pName, String pOrigName, String pQualifiedName, AInitializer pInitializer, boolean pIsFinal) {
        super(pFileLocation, false, pType, pName, pOrigName, pQualifiedName, pInitializer);
        this.isFinal = pIsFinal;
    }

    @Override
    public JType getType() {
        return (JType)super.getType();
    }

    @Override
    public String toASTString() {
        StringBuilder lASTString = new StringBuilder();
        if (this.isFinal) {
            lASTString.append("final ");
        }
        lASTString.append(this.getType().toASTString(this.getName()));
        if (this.getInitializer() != null) {
            lASTString.append(" = ");
            lASTString.append(this.getInitializer().toASTString());
        }
        lASTString.append(";");
        return lASTString.toString();
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + (this.isFinal ? 1231 : 1237);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JVariableDeclaration) || !super.equals(obj)) {
            return false;
        }
        JVariableDeclaration other = (JVariableDeclaration)obj;
        return other.isFinal == this.isFinal;
    }
}

