/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.java;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeExpression;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

public class JVariableRunTimeType
extends AbstractExpression
implements JRunTimeTypeExpression {
    private final JIdExpression referencedVariable;

    public JVariableRunTimeType(FileLocation pFileLocation, JIdExpression pReferencedVariable) {
        super(pFileLocation, pReferencedVariable.getExpressionType());
        assert (pReferencedVariable.getExpressionType() instanceof JClassOrInterfaceType || pReferencedVariable.getExpressionType() instanceof JArrayType);
        this.referencedVariable = pReferencedVariable;
        assert (this.getReferencedVariable() != null);
    }

    @Override
    public JType getExpressionType() {
        return (JType)super.getExpressionType();
    }

    @Override
    public <R, X extends Exception> R accept(JRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(JExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString() {
        return this.getReferencedVariable().getName() + "_getClass()";
    }

    public JIdExpression getReferencedVariable() {
        return this.referencedVariable;
    }

    @Override
    public boolean isThisReference() {
        return false;
    }

    @Override
    public boolean isVariableReference() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.referencedVariable);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JVariableRunTimeType) || !super.equals(obj)) {
            return false;
        }
        JVariableRunTimeType other = (JVariableRunTimeType)obj;
        return Objects.equals(other.referencedVariable, this.referencedVariable);
    }
}

