/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.blocks.ReferencedVariable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;

public class Block {
    private final ImmutableSet<ReferencedVariable> referencedVariables;
    private final ImmutableSet<CFANode> callNodes;
    private final ImmutableSet<CFANode> returnNodes;
    private final ImmutableSet<CFANode> nodes;

    public Block(Set<ReferencedVariable> pReferencedVariables, Set<CFANode> pCallNodes, Set<CFANode> pReturnNodes, Set<CFANode> allNodes) {
        this.referencedVariables = ImmutableSet.copyOf(pReferencedVariables);
        this.callNodes = ImmutableSet.copyOf(pCallNodes);
        this.returnNodes = ImmutableSet.copyOf(pReturnNodes);
        this.nodes = ImmutableSet.copyOf(allNodes);
    }

    public Set<CFANode> getCallNodes() {
        return Collections.unmodifiableSet(this.callNodes);
    }

    public CFANode getCallNode() {
        assert (this.callNodes.size() == 1);
        return (CFANode)this.callNodes.iterator().next();
    }

    public Set<ReferencedVariable> getReferencedVariables() {
        return this.referencedVariables;
    }

    public Set<CFANode> getNodes() {
        return this.nodes;
    }

    public boolean isReturnNode(CFANode pNode) {
        return this.returnNodes.contains((Object)pNode);
    }

    public Set<CFANode> getReturnNodes() {
        return this.returnNodes;
    }

    public boolean isCallNode(CFANode pNode) {
        return this.callNodes.contains((Object)pNode);
    }

    public String toString() {
        return "Block (CallNodes: " + this.callNodes + ") " + "(Nodes: " + (this.nodes.size() < 10 ? this.nodes : "[#=" + this.nodes.size() + "]") + ") " + "(ReturnNodes: " + this.returnNodes + ")";
    }
}

