/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;

public class BlockPartitioning {
    private final Block mainBlock;
    private final Map<CFANode, Block> callNodeToBlock;
    private final Map<CFANode, Block> returnNodeToBlock;
    private final Set<Block> blocks;

    public BlockPartitioning(Collection<Block> subtrees, CFANode mainFunction) {
        Block mainBlock = null;
        ImmutableMap.Builder callNodeToSubtree = new ImmutableMap.Builder();
        ImmutableMap.Builder returnNodeToBlock = new ImmutableMap.Builder();
        ImmutableSet.Builder blocks = new ImmutableSet.Builder();
        HashSet<CFANode> returnNodes = new HashSet<CFANode>();
        for (Block subtree : subtrees) {
            blocks.add((Object)subtree);
            for (CFANode callNode : subtree.getCallNodes()) {
                if (callNode instanceof FunctionEntryNode && callNode.getFunctionName().equalsIgnoreCase(mainFunction.getFunctionName())) {
                    assert (mainBlock == null);
                    mainBlock = subtree;
                }
                callNodeToSubtree.put((Object)callNode, (Object)subtree);
            }
            for (CFANode returnNode : subtree.getReturnNodes()) {
                if (!returnNodes.add(returnNode)) continue;
                returnNodeToBlock.put((Object)returnNode, (Object)subtree);
            }
        }
        assert (mainBlock != null);
        this.mainBlock = mainBlock;
        this.callNodeToBlock = callNodeToSubtree.build();
        this.returnNodeToBlock = returnNodeToBlock.build();
        this.blocks = blocks.build();
    }

    public boolean isCallNode(CFANode node) {
        return this.callNodeToBlock.containsKey(node);
    }

    public Block getBlockForCallNode(CFANode node) {
        return this.callNodeToBlock.get(node);
    }

    public Block getMainBlock() {
        return this.mainBlock;
    }

    public boolean isReturnNode(CFANode node) {
        return this.returnNodeToBlock.containsKey(node);
    }

    public Block getBlockForReturnNode(CFANode pCurrentNode) {
        return this.returnNodeToBlock.get(pCurrentNode);
    }

    public Set<Block> getBlocks() {
        return this.blocks;
    }
}

