/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class BlockToDotWriter {
    private final BlockPartitioning blockPartitioning;
    int blockIndex = 0;

    public BlockToDotWriter(BlockPartitioning blockPartitioning) {
        this.blockPartitioning = blockPartitioning;
    }

    public void dump(Path filename, LogManager logger) {
        try (Writer w = Files.openOutputFile((Path)filename, (FileWriteMode[])new FileWriteMode[0]);){
            this.dump(w);
        }
        catch (IOException e) {
            logger.logUserException(Level.WARNING, (Throwable)e, "Could not write blocks to dot file");
        }
    }

    private void dump(Appendable app) throws IOException {
        Multimap<Block, Block> hierarchy = this.getHierarchy();
        app.append("digraph blocked_CFA {\n");
        ArrayList<CFAEdge> edges = new ArrayList<CFAEdge>();
        this.dumpBlock(app, new HashSet<CFANode>(), this.blockPartitioning.getMainBlock(), hierarchy, edges, 0);
        for (CFAEdge edge : edges) {
            app.append(BlockToDotWriter.formatEdge(edge));
        }
        app.append("}");
    }

    private Multimap<Block, Block> getHierarchy() {
        ArrayList sortedBlocks = Lists.newArrayList(this.blockPartitioning.getBlocks());
        Collections.sort(sortedBlocks, new Comparator<Block>(){

            @Override
            public int compare(Block b1, Block b2) {
                return b2.getNodes().size() - b1.getNodes().size();
            }
        });
        HashMultimap hierarchy = HashMultimap.create();
        block0: while (!sortedBlocks.isEmpty()) {
            Block currentBlock = (Block)sortedBlocks.remove(sortedBlocks.size() - 1);
            for (Block possibleOuterBlock : Lists.reverse((List)sortedBlocks)) {
                if (!possibleOuterBlock.getNodes().contains(currentBlock.getNodes().iterator().next())) continue;
                hierarchy.put((Object)possibleOuterBlock, (Object)currentBlock);
                continue block0;
            }
        }
        assert (hierarchy.values().size() <= this.blockPartitioning.getBlocks().size() - 1) : "all blocks except mainBlock might appear at most once as child.";
        return hierarchy;
    }

    private void dumpBlock(Appendable app, Set<CFANode> finished, Block block, Multimap<Block, Block> hierarchy, List<CFAEdge> edges, int depth) throws IOException {
        String blockname = block == this.blockPartitioning.getMainBlock() ? "main_block" : "block_" + this.blockIndex++;
        app.append("subgraph cluster_" + blockname + " {\n");
        app.append("style=filled\n");
        app.append("fillcolor=" + (depth % 2 == 0 ? "white" : "lightgrey") + "\n");
        app.append("label=\"" + blockname + "\"\n");
        for (Block innerBlock : hierarchy.get((Object)block)) {
            this.dumpBlock(app, finished, innerBlock, hierarchy, edges, depth + 1);
        }
        for (CFANode node : block.getNodes()) {
            if (!finished.add(node)) continue;
            app.append(this.formatNode(node));
            Iterables.addAll(edges, CFAUtils.leavingEdges(node));
            FunctionSummaryEdge func = node.getEnteringSummaryEdge();
            if (func == null) continue;
            edges.add(func);
        }
        app.append("}\n");
    }

    private String formatNode(CFANode node) {
        String color = "";
        if (this.blockPartitioning.isCallNode(node) && this.blockPartitioning.isReturnNode(node)) {
            color = "style=filled penwidth=6 fillcolor=green color=red ";
        } else if (this.blockPartitioning.isCallNode(node)) {
            color = "style=filled fillcolor=green ";
        } else if (this.blockPartitioning.isReturnNode(node)) {
            color = "style=filled fillcolor=red ";
        }
        String shape = "";
        if (node.isLoopStart()) {
            shape = "shape=doubleoctagon ";
        } else if (node.getNumLeavingEdges() > 0 && node.getLeavingEdge(0).getEdgeType() == CFAEdgeType.AssumeEdge) {
            shape = "shape=diamond ";
        }
        String label = "label=\"" + node.getNodeNumber() + "\\n" + node.getReversePostorderId() + "\" ";
        return node.getNodeNumber() + " [" + shape + label + color + "]\n";
    }

    private static String formatEdge(CFAEdge edge) {
        StringBuilder sb = new StringBuilder();
        sb.append(edge.getPredecessor().getNodeNumber());
        sb.append(" -> ");
        sb.append(edge.getSuccessor().getNodeNumber());
        sb.append(" [label=\"");
        sb.append(edge.getDescription().replaceAll("\\Q\\\"\\E", "\\ \"").replaceAll("\\\"", "\\\\\\\"").replaceAll("\n", " "));
        sb.append("\"");
        if (edge instanceof FunctionSummaryEdge) {
            sb.append(" style=\"dotted\" arrowhead=\"empty\"");
        } else if (edge instanceof FunctionCallEdge) {
            sb.append(" style=\"dashed\" arrowhead=\"empty\"");
        } else if (edge instanceof FunctionReturnEdge) {
            sb.append(" style=\"dashed\" arrowhead=\"empty\"");
        }
        sb.append("]\n");
        return sb.toString();
    }
}

