/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.ReferencedVariable;
import org.sosy_lab.cpachecker.cfa.blocks.builder.ReferencedVariablesCollector;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;

public class BlockPartitioningBuilder {
    private static final CFATraversal TRAVERSE_CFA_INSIDE_FUNCTION = CFATraversal.dfs().ignoreFunctionCalls();
    private final Map<CFANode, Set<ReferencedVariable>> referencedVariablesMap = new HashMap<CFANode, Set<ReferencedVariable>>();
    private final Map<CFANode, Set<CFANode>> callNodesMap = new HashMap<CFANode, Set<CFANode>>();
    private final Map<CFANode, Set<CFANode>> returnNodesMap = new HashMap<CFANode, Set<CFANode>>();
    private final Map<CFANode, Set<FunctionEntryNode>> innerFunctionCallsMap = new HashMap<CFANode, Set<FunctionEntryNode>>();
    private final Map<CFANode, Set<CFANode>> blockNodesMap = new HashMap<CFANode, Set<CFANode>>();

    public BlockPartitioning build(CFANode mainFunction) {
        boolean changed = true;
        block0: while (changed) {
            changed = false;
            for (CFANode node : this.referencedVariablesMap.keySet()) {
                for (CFANode cFANode : this.innerFunctionCallsMap.get(node)) {
                    Set<ReferencedVariable> functionVars = this.referencedVariablesMap.get(cFANode);
                    Set<CFANode> functionBody = this.blockNodesMap.get(cFANode);
                    if (functionVars == null || functionBody == null) {
                        assert (functionVars == null && functionBody == null);
                        functionBody = TRAVERSE_CFA_INSIDE_FUNCTION.collectNodesReachableFrom(cFANode);
                        functionVars = this.collectReferencedVariables(functionBody);
                        this.blockNodesMap.put(cFANode, functionBody);
                        this.referencedVariablesMap.put(cFANode, functionVars);
                        this.innerFunctionCallsMap.put(cFANode, this.collectInnerFunctionCalls(functionBody));
                        changed = true;
                        continue block0;
                    }
                    if (this.referencedVariablesMap.get(node).addAll(functionVars)) {
                        changed = true;
                    }
                    if (!this.blockNodesMap.get(node).addAll(functionBody)) continue;
                    changed = true;
                }
            }
        }
        ArrayList<Block> blocks = new ArrayList<Block>(this.returnNodesMap.keySet().size());
        for (CFANode key : this.returnNodesMap.keySet()) {
            blocks.add(new Block(this.referencedVariablesMap.get(key), this.callNodesMap.get(key), this.returnNodesMap.get(key), this.blockNodesMap.get(key)));
        }
        return new BlockPartitioning(blocks, mainFunction);
    }

    public void addBlock(Set<CFANode> nodes, CFANode mainFunction) {
        Set<ReferencedVariable> referencedVariables = this.collectReferencedVariables(nodes);
        Set<CFANode> callNodes = this.collectCallNodes(nodes, mainFunction);
        Set<CFANode> returnNodes = this.collectReturnNodes(nodes, mainFunction);
        Set<FunctionEntryNode> innerFunctionCalls = this.collectInnerFunctionCalls(nodes);
        CFANode registerNode = null;
        Iterator<CFANode> i$ = callNodes.iterator();
        while (i$.hasNext()) {
            CFANode node;
            registerNode = node = i$.next();
            if (!(node instanceof FunctionEntryNode)) continue;
            break;
        }
        this.referencedVariablesMap.put(registerNode, referencedVariables);
        this.callNodesMap.put(registerNode, callNodes);
        this.returnNodesMap.put(registerNode, returnNodes);
        this.innerFunctionCallsMap.put(registerNode, innerFunctionCalls);
        this.blockNodesMap.put(registerNode, nodes);
    }

    private Set<FunctionEntryNode> collectInnerFunctionCalls(Set<CFANode> pNodes) {
        HashSet<FunctionEntryNode> result = new HashSet<FunctionEntryNode>();
        for (CFANode node : pNodes) {
            for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
                CFAEdge e = node.getLeavingEdge(i);
                if (!(e instanceof CFunctionCallEdge)) continue;
                result.add(((CFunctionCallEdge)e).getSuccessor());
            }
        }
        return result;
    }

    private Set<CFANode> collectCallNodes(Set<CFANode> pNodes, CFANode mainFunction) {
        HashSet<CFANode> result = new HashSet<CFANode>();
        for (CFANode node : pNodes) {
            if (node instanceof FunctionEntryNode && node.getFunctionName().equalsIgnoreCase(mainFunction.getFunctionName())) {
                result.add(node);
                continue;
            }
            if (node.getEnteringSummaryEdge() != null) {
                CFANode pred = node.getEnteringSummaryEdge().getPredecessor();
                if (pNodes.contains(pred)) continue;
                result.add(node);
                continue;
            }
            for (int i = 0; i < node.getNumEnteringEdges(); ++i) {
                CFANode pred = node.getEnteringEdge(i).getPredecessor();
                if (pNodes.contains(pred)) continue;
                result.add(node);
            }
        }
        return result;
    }

    private Set<CFANode> collectReturnNodes(Set<CFANode> pNodes, CFANode mainFunction) {
        HashSet<CFANode> result = new HashSet<CFANode>();
        for (CFANode node : pNodes) {
            if (node instanceof FunctionExitNode && node.getFunctionName().equalsIgnoreCase(mainFunction.getFunctionName())) {
                result.add(node);
                continue;
            }
            for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
                CFANode succ = node.getLeavingEdge(i).getSuccessor();
                if (pNodes.contains(succ)) continue;
                if (!(node.getLeavingEdge(i) instanceof CFunctionCallEdge)) {
                    result.add(node);
                    continue;
                }
                CFANode sumSucc = ((CFunctionCallEdge)node.getLeavingEdge(i)).getSummaryEdge().getSuccessor();
                if (pNodes.contains(sumSucc)) continue;
                for (int j = 0; j < sumSucc.getNumEnteringEdges(); ++j) {
                    result.add(sumSucc.getEnteringEdge(j).getPredecessor());
                }
            }
        }
        return result;
    }

    private Set<ReferencedVariable> collectReferencedVariables(Set<CFANode> nodes) {
        return new ReferencedVariablesCollector(nodes).getVars();
    }
}

