/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import java.util.Set;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.builder.FunctionPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.builder.LoopPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.builder.PartitioningHeuristic;
import org.sosy_lab.cpachecker.cfa.model.CFANode;

public class FunctionAndLoopPartitioning
extends PartitioningHeuristic {
    private FunctionPartitioning functionPartitioning;
    private LoopPartitioning loopPartitioning;

    public FunctionAndLoopPartitioning(LogManager pLogger, CFA pCfa) {
        super(pLogger, pCfa);
        this.functionPartitioning = new FunctionPartitioning(pLogger, pCfa);
        this.loopPartitioning = new LoopPartitioning(pLogger, pCfa);
    }

    @Override
    protected boolean shouldBeCached(CFANode pNode) {
        return this.functionPartitioning.shouldBeCached(pNode) || this.loopPartitioning.shouldBeCached(pNode);
    }

    @Override
    protected Set<CFANode> getBlockForNode(CFANode pNode) {
        if (this.functionPartitioning.shouldBeCached(pNode)) {
            return this.functionPartitioning.getBlockForNode(pNode);
        }
        if (this.loopPartitioning.shouldBeCached(pNode)) {
            return this.loopPartitioning.getBlockForNode(pNode);
        }
        throw new AssertionError((Object)("node should not be cached: " + pNode));
    }
}

