/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.builder.PartitioningHeuristic;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.util.CFATraversal;

public class FunctionPartitioning
extends PartitioningHeuristic {
    private static final CFATraversal TRAVERSE_CFA_INSIDE_FUNCTION = CFATraversal.dfs().ignoreFunctionCalls();

    public FunctionPartitioning(LogManager pLogger, CFA pCfa) {
        super(pLogger, pCfa);
    }

    @Override
    protected boolean shouldBeCached(CFANode pNode) {
        if (pNode.getFunctionName().startsWith("__VERIFIER_")) {
            return false;
        }
        return pNode instanceof FunctionEntryNode;
    }

    @Override
    protected Set<CFANode> getBlockForNode(CFANode pNode) {
        Preconditions.checkArgument((boolean)this.shouldBeCached(pNode));
        Set<CFANode> blockNodes = TRAVERSE_CFA_INSIDE_FUNCTION.collectNodesReachableFrom(pNode);
        return blockNodes;
    }
}

