/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.builder.PartitioningHeuristic;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;

public class LoopPartitioning
extends PartitioningHeuristic {
    private Map<CFANode, Set<CFANode>> loopHeaderToLoopBody = null;

    public LoopPartitioning(LogManager pLogger, CFA pCfa) {
        super(pLogger, pCfa);
    }

    private void initLoopMap() {
        this.loopHeaderToLoopBody = new HashMap<CFANode, Set<CFANode>>();
        if (this.cfa.getLoopStructure().isPresent()) {
            for (LoopStructure.Loop loop : ((LoopStructure)this.cfa.getLoopStructure().get()).getAllLoops()) {
                if (loop.getLoopHeads().size() != 1) continue;
                this.loopHeaderToLoopBody.put((CFANode)Iterables.getOnlyElement(loop.getLoopHeads()), (Set<CFANode>)loop.getLoopNodes());
            }
        }
    }

    @Override
    protected boolean shouldBeCached(CFANode pNode) {
        if (this.isMainFunction(pNode)) {
            Preconditions.checkArgument((boolean)this.cfa.getMainFunction().getFunctionName().equals(pNode.getFunctionName()));
            return true;
        }
        return this.isLoopHead(pNode) && !this.hasBlankEdgeFromLoop(pNode) && !LoopPartitioning.selfLoop(pNode);
    }

    private boolean isMainFunction(CFANode pNode) {
        return pNode instanceof FunctionEntryNode && pNode.getNumEnteringEdges() == 0;
    }

    private boolean isLoopHead(CFANode pNode) {
        return ((ImmutableSet)this.cfa.getAllLoopHeads().get()).contains((Object)pNode);
    }

    private boolean hasBlankEdgeFromLoop(CFANode pNode) {
        for (CFAEdge edge : CFAUtils.enteringEdges(pNode)) {
            if (!(edge instanceof BlankEdge) || !this.isLoopHead(edge.getPredecessor())) continue;
            return true;
        }
        return false;
    }

    private static boolean selfLoop(CFANode pNode) {
        return pNode.getNumLeavingEdges() == 1 && pNode.getLeavingEdge(0).getSuccessor().equals(pNode);
    }

    @Override
    protected Set<CFANode> getBlockForNode(CFANode pNode) {
        Preconditions.checkArgument((boolean)this.shouldBeCached(pNode));
        if (this.isMainFunction(pNode)) {
            return CFATraversal.dfs().ignoreFunctionCalls().collectNodesReachableFrom(pNode);
        }
        if (this.loopHeaderToLoopBody == null) {
            this.initLoopMap();
        }
        if (!this.loopHeaderToLoopBody.containsKey(pNode)) {
            return null;
        }
        HashSet<CFANode> loopBody = new HashSet<CFANode>((Collection)this.loopHeaderToLoopBody.get(pNode));
        this.insertLoopStartState(loopBody, pNode);
        this.insertLoopReturnStates(loopBody);
        return loopBody;
    }

    private void insertLoopStartState(Set<CFANode> pLoopBody, CFANode pLoopHeader) {
        for (CFAEdge edge : CFAUtils.enteringEdges(pLoopHeader)) {
            if (!(edge instanceof BlankEdge) || pLoopBody.contains(edge.getPredecessor())) continue;
            pLoopBody.add(edge.getPredecessor());
        }
    }

    private void insertLoopReturnStates(Set<CFANode> pLoopBody) {
        ArrayList<CFANode> addNodes = new ArrayList<CFANode>();
        for (CFANode node : pLoopBody) {
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                if (pLoopBody.contains(edge.getSuccessor()) || edge.getEdgeType() == CFAEdgeType.FunctionCallEdge) continue;
                addNodes.add(edge.getSuccessor());
            }
        }
        ArrayList<CFANode> waitlist = new ArrayList<CFANode>(addNodes);
        while (!waitlist.isEmpty()) {
            CFANode node;
            node = (CFANode)waitlist.remove(0);
            if (!pLoopBody.add(node)) continue;
            for (CFANode pred : CFAUtils.predecessorsOf(node)) {
                waitlist.add(pred);
            }
        }
    }
}

