/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.builder.BlockPartitioningBuilder;
import org.sosy_lab.cpachecker.cfa.model.CFANode;

public abstract class PartitioningHeuristic {
    protected final CFA cfa;
    protected final LogManager logger;

    public PartitioningHeuristic(LogManager pLogger, CFA pCfa) {
        this.cfa = pCfa;
        this.logger = pLogger;
    }

    public final BlockPartitioning buildPartitioning(CFANode mainFunction) {
        BlockPartitioningBuilder builder = new BlockPartitioningBuilder();
        HashSet<CFANode> seen = new HashSet<CFANode>();
        ArrayDeque<CFANode> stack = new ArrayDeque<CFANode>();
        seen.add(mainFunction);
        stack.push(mainFunction);
        while (!stack.isEmpty()) {
            Set<CFANode> subtree;
            CFANode node = (CFANode)stack.pop();
            if (this.shouldBeCached(node) && (subtree = this.getBlockForNode(node)) != null) {
                builder.addBlock(subtree, mainFunction);
            }
            for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
                CFANode nextNode = node.getLeavingEdge(i).getSuccessor();
                if (seen.contains(nextNode)) continue;
                stack.push(nextNode);
                seen.add(nextNode);
            }
        }
        return builder.build(mainFunction);
    }

    protected abstract boolean shouldBeCached(CFANode var1);

    protected abstract Set<CFANode> getBlockForNode(CFANode var1);
}

