/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.export;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;

public final class DOTBuilder {
    private static final String MAIN_GRAPH = "____Main____Diagram__";
    private static final Joiner JOINER_ON_NEWLINE = Joiner.on((char)'\n');
    private static final int NODE_SHAPE_CHANGE_CHAR_LIMIT = 10;
    private static final Function<CFANode, String> DEFAULT_NODE_FORMATTER = new Function<CFANode, String>(){

        public String apply(CFANode node) {
            return "N" + node.getNodeNumber() + "\\n" + node.getReversePostorderId();
        }
    };

    private DOTBuilder() {
    }

    public static void generateDOT(Appendable sb, CFA cfa) throws IOException {
        DOTBuilder.generateDOT(sb, cfa, DEFAULT_NODE_FORMATTER);
    }

    public static void generateDOT(Appendable sb, CFA cfa, Function<CFANode, String> formatNodeLabel) throws IOException {
        DotGenerator dotGenerator = new DotGenerator(cfa, formatNodeLabel);
        CFATraversal.dfs().traverseOnce(cfa.getMainFunction(), dotGenerator);
        sb.append("digraph CFA {\n");
        JOINER_ON_NEWLINE.appendTo(sb, (Iterable)dotGenerator.nodes);
        sb.append('\n');
        sb.append("node [shape=\"circle\"]\n");
        for (FunctionEntryNode fnode : cfa.getAllFunctionHeads()) {
            sb.append("subgraph cluster_" + fnode.getFunctionName().replace("[", "").replace("]", "_array").replace(".", "_") + " {\n");
            sb.append("label=\"" + fnode.getFunctionName() + "()\"\n");
            JOINER_ON_NEWLINE.appendTo(sb, (Iterable)dotGenerator.edges.get((Object)fnode.getFunctionName()));
            sb.append("}\n");
        }
        JOINER_ON_NEWLINE.appendTo(sb, (Iterable)dotGenerator.edges.get((Object)MAIN_GRAPH));
        sb.append("}");
    }

    static String formatNode(CFANode node, Optional<ImmutableSet<CFANode>> loopHeads) {
        return DOTBuilder.formatNode(node, loopHeads, DEFAULT_NODE_FORMATTER);
    }

    static String formatNode(CFANode node, Optional<ImmutableSet<CFANode>> loopHeads, Function<CFANode, String> formatNodeLabel) {
        String nodeAnnotation = (String)formatNodeLabel.apply((Object)node);
        String string = nodeAnnotation = nodeAnnotation != null ? nodeAnnotation : "";
        String shape = nodeAnnotation.length() > 10 ? "box" : (loopHeads.isPresent() && ((ImmutableSet)loopHeads.get()).contains((Object)node) ? "doublecircle" : (node.isLoopStart() ? "doubleoctagon" : (node.getNumLeavingEdges() > 0 && node.getLeavingEdge(0).getEdgeType() == CFAEdgeType.AssumeEdge ? "diamond" : "circle")));
        return node.getNodeNumber() + " [shape=\"" + shape + "\" label=\"" + DOTBuilder.escapeGraphvizLabel(nodeAnnotation, "\\\\n") + "\"]";
    }

    public static String escapeGraphvizLabel(String input, String newlineReplacement) {
        return input.replaceAll("\\Q\\\"\\E", "\\ \"").replaceAll("\\\"", "\\\\\\\"").replaceAll("\n", newlineReplacement);
    }

    private static class DotGenerator
    implements CFATraversal.CFAVisitor {
        private final List<String> nodes = new ArrayList<String>();
        private final ListMultimap<String, String> edges = ArrayListMultimap.create();
        private final Optional<ImmutableSet<CFANode>> loopHeads;
        private final Function<CFANode, String> formatNodeLabel;

        public DotGenerator(CFA cfa, Function<CFANode, String> pFormatNodeLabel) {
            this.loopHeads = cfa.getAllLoopHeads();
            this.formatNodeLabel = pFormatNodeLabel;
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge edge) {
            CFANode predecessor = edge.getPredecessor();
            List graph = edge.getEdgeType() == CFAEdgeType.FunctionCallEdge || edge.getEdgeType() == CFAEdgeType.FunctionReturnEdge ? this.edges.get((Object)DOTBuilder.MAIN_GRAPH) : this.edges.get((Object)predecessor.getFunctionName());
            graph.add(DotGenerator.formatEdge(edge));
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode node) {
            this.nodes.add(DOTBuilder.formatNode(node, this.loopHeads, this.formatNodeLabel));
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        private static String formatEdge(CFAEdge edge) {
            StringBuilder sb = new StringBuilder();
            sb.append(edge.getPredecessor().getNodeNumber());
            sb.append(" -> ");
            sb.append(edge.getSuccessor().getNodeNumber());
            sb.append(" [label=\"");
            sb.append(DOTBuilder.escapeGraphvizLabel(edge.getDescription(), " "));
            sb.append("\"");
            if (edge instanceof FunctionSummaryEdge) {
                sb.append(" style=\"dotted\" arrowhead=\"empty\"");
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

