/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.export;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.JSON;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;

public final class DOTBuilder2 {
    private DOTBuilder2() {
    }

    public static void writeReport(CFA cfa, Path outdir) throws IOException {
        CFAJSONBuilder jsoner = new CFAJSONBuilder();
        DOTViewBuilder dotter = new DOTViewBuilder(cfa);
        CFATraversal.NodeCollectingCFAVisitor vis = new CFATraversal.NodeCollectingCFAVisitor(new CFATraversal.CompositeCFAVisitor(jsoner, dotter));
        for (FunctionEntryNode entryNode : cfa.getAllFunctionHeads()) {
            CFATraversal.dfs().ignoreFunctionCalls().traverse(entryNode, vis);
            dotter.writeFunctionFile(entryNode.getFunctionName(), outdir);
        }
        dotter.writeGlobalFiles(outdir);
        JSON.writeJSONString(jsoner.getJSON(), (Path)outdir.resolve("cfainfo.json"));
    }

    private static String getEdgeText(CFAEdge edge) {
        return edge.getDescription().replaceAll("\\Q\\\"\\E", "\\ \"").replaceAll("\\\"", "\\\\\\\"").replaceAll("\n", " ").replaceAll("\\s+", " ").replaceAll(" ;", ";");
    }

    private static class CFAJSONBuilder
    extends CFATraversal.DefaultCFAVisitor {
        private final Map<Object, Object> nodes = new HashMap<Object, Object>();
        private final Map<Object, Object> edges = new HashMap<Object, Object>();

        private CFAJSONBuilder() {
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode node) {
            HashMap<String, Object> jnode = new HashMap<String, Object>();
            jnode.put("no", node.getNodeNumber());
            jnode.put("func", node.getFunctionName());
            this.nodes.put(node.getNodeNumber(), jnode);
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge edge) {
            HashMap<String, Object> jedge = new HashMap<String, Object>();
            int src = edge.getPredecessor().getNodeNumber();
            int target = edge.getSuccessor().getNodeNumber();
            jedge.put("line", edge.getFileLocation().getStartingLineNumber());
            jedge.put("file", edge.getFileLocation().getFileName());
            jedge.put("source", src);
            jedge.put("target", target);
            jedge.put("stmt", DOTBuilder2.getEdgeText(edge));
            jedge.put("type", edge.getEdgeType().toString());
            this.edges.put("" + src + "->" + target, jedge);
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        Map<String, Object> getJSON() {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("nodes", this.nodes);
            obj.put("edges", this.edges);
            return obj;
        }
    }

    private static class DOTViewBuilder
    extends CFATraversal.DefaultCFAVisitor {
        private final Map<Object, Object> node2combo = new HashMap<Object, Object>();
        private final Map<Object, Object> virtFuncCallEdges = new HashMap<Object, Object>();
        private int virtFuncCallNodeIdCounter = 100000;
        private final Set<CFANode> nodes = Sets.newLinkedHashSet();
        private final List<CFAEdge> edges = Lists.newArrayList();
        private final List<List<CFAEdge>> comboedges = Lists.newArrayList();
        private List<CFAEdge> currentComboEdge = null;
        private final Optional<ImmutableSet<CFANode>> loopHeads;

        private DOTViewBuilder(CFA cfa) {
            this.loopHeads = cfa.getAllLoopHeads();
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge edge) {
            CFANode predecessor = edge.getPredecessor();
            if (predecessor.isLoopStart() || predecessor.getNumEnteringEdges() != 1 || predecessor.getNumLeavingEdges() != 1 || this.currentComboEdge != null && !predecessor.equals(this.currentComboEdge.get(this.currentComboEdge.size() - 1).getSuccessor()) || edge.getEdgeType() == CFAEdgeType.CallToReturnEdge || edge.getEdgeType() == CFAEdgeType.AssumeEdge) {
                this.edges.add(edge);
                this.currentComboEdge = null;
                this.nodes.add(predecessor);
                this.nodes.add(edge.getSuccessor());
            } else {
                if (this.currentComboEdge == null) {
                    this.currentComboEdge = Lists.newArrayList();
                    this.comboedges.add(this.currentComboEdge);
                }
                this.currentComboEdge.add(edge);
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        void writeFunctionFile(String funcname, Path outdir) throws IOException {
            try (Writer out = outdir.resolve("cfa__" + funcname + ".dot").asCharSink(StandardCharsets.UTF_8, new FileWriteMode[0]).openBufferedStream();){
                out.write("digraph " + funcname + " {\n");
                StringBuilder outb = new StringBuilder();
                for (List<CFAEdge> combo : this.comboedges) {
                    if (combo.size() == 1) {
                        this.edges.add(combo.get(0));
                        this.nodes.add(combo.get(0).getPredecessor());
                        this.nodes.add(combo.get(0).getSuccessor());
                        continue;
                    }
                    outb.append(this.comboToDot(combo));
                    CFAEdge first = combo.get(0);
                    CFAEdge last = combo.get(combo.size() - 1);
                    outb.append(first.getPredecessor().getNodeNumber());
                    outb.append(" -> ");
                    outb.append(last.getSuccessor().getNodeNumber());
                    outb.append("[label=\"\"]\n");
                }
                for (CFANode node : this.nodes) {
                    out.write(DOTBuilder.formatNode(node, this.loopHeads));
                    out.write(10);
                }
                out.write(outb.toString());
                for (CFAEdge edge : this.edges) {
                    out.write(this.edgeToDot(edge));
                }
                out.write("}");
                this.nodes.clear();
                this.edges.clear();
                this.comboedges.clear();
            }
        }

        void writeGlobalFiles(Path outdir) throws IOException {
            JSON.writeJSONString(this.node2combo, (Path)outdir.resolve("combinednodes.json"));
            JSON.writeJSONString(this.virtFuncCallEdges, (Path)outdir.resolve("fcalledges.json"));
        }

        private String edgeToDot(CFAEdge edge) {
            if (edge.getEdgeType() == CFAEdgeType.CallToReturnEdge) {
                CFANode functionEntryNode = (CFANode)Iterables.getOnlyElement((Iterable)CFAUtils.successorsOf(edge.getPredecessor()).filter(FunctionEntryNode.class));
                String calledFunction = functionEntryNode.getFunctionName();
                String ret = ++this.virtFuncCallNodeIdCounter + " [shape=\"component\" label=\"" + calledFunction + "\"]\n";
                int from = edge.getPredecessor().getNodeNumber();
                ret = ret + String.format("%d -> %d [label=\"%s\" fontname=\"Courier New\"]%n", from, this.virtFuncCallNodeIdCounter, DOTBuilder2.getEdgeText(edge));
                int to = edge.getSuccessor().getNodeNumber();
                ret = ret + String.format("%d -> %d [label=\"\" fontname=\"Courier New\"]%n", this.virtFuncCallNodeIdCounter, to);
                this.virtFuncCallEdges.put(from, Lists.newArrayList((Object[])new Integer[]{this.virtFuncCallNodeIdCounter, to}));
                return ret;
            }
            return String.format("%d -> %d [label=\"%s\" fontname=\"Courier New\"]%n", edge.getPredecessor().getNodeNumber(), edge.getSuccessor().getNodeNumber(), DOTBuilder2.getEdgeText(edge));
        }

        private String comboToDot(List<CFAEdge> combo) {
            CFAEdge first = combo.get(0);
            StringBuilder sb = new StringBuilder();
            int firstNo = first.getPredecessor().getNodeNumber();
            sb.append(firstNo);
            sb.append(" [style=\"filled,bold\" penwidth=\"1\" fillcolor=\"white\" fontname=\"Courier New\" shape=\"Mrecord\" label=");
            if (combo.size() > 20) {
                CFAEdge last = combo.get(combo.size() - 1);
                int lastNo = last.getPredecessor().getNodeNumber();
                sb.append("\"Long linear chain of edges between nodes ");
                sb.append(firstNo);
                sb.append(" and ");
                sb.append(lastNo);
                sb.append('\"');
            } else {
                sb.append("<<table border=\"0\" cellborder=\"0\" cellpadding=\"3\" bgcolor=\"white\">");
                for (CFAEdge edge : combo) {
                    sb.append("<tr><td align=\"right\">");
                    sb.append("" + edge.getPredecessor().getNodeNumber());
                    sb.append("</td><td align=\"left\">");
                    sb.append("" + DOTBuilder2.getEdgeText(edge).replaceAll("\\|", "&#124;").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\\{", "&#123;").replaceAll("\\}", "&#125;"));
                    sb.append("</td></tr>");
                }
                sb.append("</table>>");
            }
            for (CFAEdge edge : combo) {
                this.node2combo.put(edge.getPredecessor().getNodeNumber(), firstNo);
            }
            sb.append("]\n");
            return sb.toString();
        }
    }
}

